/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedArrayTypeImpl;
import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.AnnotatedCaptureTypeImpl;
import io.leangen.geantyref.AnnotatedParameterizedTypeImpl;
import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.AnnotatedTypeVariableImpl;
import io.leangen.geantyref.AnnotatedWildcardTypeImpl;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.GenericArrayTypeImpl;
import io.leangen.geantyref.ParameterizedTypeImpl;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.UnresolvedTypeVariableException;
import io.leangen.geantyref.VarMap;
import io.leangen.geantyref.WildcardTypeImpl;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Stream;

public class GenericTypeReflector {
    private static final WildcardType UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (tv.getBounds().length == 0) {
                return Object.class;
            }
            return GenericTypeReflector.erase(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.erase(aType.getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            return GenericTypeReflector.erase(lowerBounds.length > 0 ? lowerBounds[0] : wildcardType.getUpperBounds()[0]);
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }

    public static AnnotatedType mapTypeParameters(AnnotatedType toMapType, AnnotatedType typeAndParams) {
        return GenericTypeReflector.mapTypeParameters(toMapType, typeAndParams, VarMap.MappingMode.EXACT);
    }

    private static AnnotatedType mapTypeParameters(AnnotatedType toMapType, AnnotatedType typeAndParams, VarMap.MappingMode mappingMode) {
        if (GenericTypeReflector.isMissingTypeParameters(typeAndParams.getType())) {
            return new AnnotatedTypeImpl(GenericTypeReflector.erase(toMapType.getType()), toMapType.getAnnotations());
        }
        VarMap varMap = new VarMap();
        AnnotatedType handlingTypeAndParams = typeAndParams;
        while (handlingTypeAndParams instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType pType = (AnnotatedParameterizedType)handlingTypeAndParams;
            Class clazz = (Class)((ParameterizedType)pType.getType()).getRawType();
            TypeVariable[] vars = clazz.getTypeParameters();
            varMap.addAll(vars, pType.getAnnotatedActualTypeArguments());
            Type owner = ((ParameterizedType)pType.getType()).getOwnerType();
            handlingTypeAndParams = owner == null ? null : GenericTypeReflector.annotate(owner);
        }
        return varMap.map(toMapType, mappingMode);
    }

    public static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public static Type addWildcardParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
        }
        if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
            TypeVariable<Class<?>>[] vars = clazz.getTypeParameters();
            Object[] arguments = new Type[vars.length];
            Arrays.fill(arguments, UNBOUND_WILDCARD);
            Type owner = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, (Type[])arguments, owner);
        }
        return clazz;
    }

    public static AnnotatedType getExactSuperType(AnnotatedType subType, Class<?> searchSuperClass) {
        if (subType instanceof AnnotatedParameterizedType || subType.getType() instanceof Class || subType instanceof AnnotatedArrayType) {
            Class<?> superClass = GenericTypeReflector.erase(subType.getType());
            if (searchSuperClass == superClass) {
                return subType;
            }
            if (!searchSuperClass.isAssignableFrom(superClass)) {
                return null;
            }
        }
        for (AnnotatedType superType : GenericTypeReflector.getExactDirectSuperTypes(subType)) {
            AnnotatedType result = GenericTypeReflector.getExactSuperType(superType, searchSuperClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Type getExactSuperType(Type subType, Class<?> searchSuperClass) {
        AnnotatedType superType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.annotate(subType), searchSuperClass);
        return superType == null ? null : superType.getType();
    }

    public static AnnotatedType getExactSubType(AnnotatedType superType, Class<?> searchSubClass) {
        Type subType = searchSubClass;
        if (searchSubClass.getTypeParameters().length > 0) {
            subType = TypeFactory.parameterizedClass(searchSubClass, searchSubClass.getTypeParameters());
        }
        AnnotatedType annotatedSubType = GenericTypeReflector.annotate(subType);
        Class<?> rawSuperType = GenericTypeReflector.erase(superType.getType());
        if (searchSubClass.isArray() && superType instanceof AnnotatedArrayType) {
            if (rawSuperType.isAssignableFrom(searchSubClass)) {
                return AnnotatedArrayTypeImpl.createArrayType(GenericTypeReflector.getExactSubType(((AnnotatedArrayType)superType).getAnnotatedGenericComponentType(), searchSubClass.getComponentType()), new Annotation[0]);
            }
            return null;
        }
        if (searchSubClass.getTypeParameters().length == 0) {
            return annotatedSubType;
        }
        if (!(superType instanceof AnnotatedParameterizedType)) {
            return GenericTypeReflector.annotate(searchSubClass);
        }
        AnnotatedParameterizedType parameterizedSuperType = (AnnotatedParameterizedType)superType;
        AnnotatedParameterizedType matched = (AnnotatedParameterizedType)GenericTypeReflector.getExactSuperType(annotatedSubType, rawSuperType);
        if (matched == null) {
            return null;
        }
        VarMap varMap = new VarMap();
        for (int i = 0; i < parameterizedSuperType.getAnnotatedActualTypeArguments().length; ++i) {
            Type var = matched.getAnnotatedActualTypeArguments()[i].getType();
            if (!(var instanceof TypeVariable) || ((TypeVariable)var).getGenericDeclaration() != searchSubClass) continue;
            varMap.add((TypeVariable)var, parameterizedSuperType.getAnnotatedActualTypeArguments()[i]);
        }
        try {
            return varMap.map(annotatedSubType);
        }
        catch (UnresolvedTypeVariableException e) {
            return GenericTypeReflector.annotate(searchSubClass);
        }
    }

    public static Type getExactSubType(Type superType, Class<?> searchSubClass) {
        AnnotatedType resolvedSubtype = GenericTypeReflector.getExactSubType(GenericTypeReflector.annotate(superType), searchSubClass);
        return resolvedSubtype == null ? null : resolvedSubtype.getType();
    }

    public static AnnotatedType getTypeParameter(AnnotatedType type, TypeVariable<? extends Class<?>> variable) {
        Class<?> clazz = variable.getGenericDeclaration();
        AnnotatedType superType = GenericTypeReflector.getExactSuperType(type, clazz);
        if (superType instanceof AnnotatedParameterizedType) {
            int index = Arrays.asList(clazz.getTypeParameters()).indexOf(variable);
            AnnotatedType resolvedVarType = ((AnnotatedParameterizedType)superType).getAnnotatedActualTypeArguments()[index];
            return GenericTypeReflector.updateAnnotations(resolvedVarType, variable.getAnnotations());
        }
        return null;
    }

    public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> variable) {
        AnnotatedType typeParameter = GenericTypeReflector.getTypeParameter(GenericTypeReflector.annotate(type), variable);
        return typeParameter == null ? null : typeParameter.getType();
    }

    public static boolean isSuperType(Type superType, Type subType) {
        if (superType instanceof ParameterizedType || superType instanceof Class || superType instanceof GenericArrayType) {
            Type mappedSubType;
            Class<?> superClass = GenericTypeReflector.erase(superType);
            AnnotatedType annotatedMappedSubType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(GenericTypeReflector.annotate(subType)), superClass);
            Type type = mappedSubType = annotatedMappedSubType == null ? null : annotatedMappedSubType.getType();
            if (mappedSubType == null) {
                return false;
            }
            if (superType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof GenericArrayType) {
                Type superComponentType = GenericTypeReflector.getArrayComponentType(superType);
                assert (superComponentType != null);
                Type mappedSubComponentType = GenericTypeReflector.getArrayComponentType(mappedSubType);
                assert (mappedSubComponentType != null);
                return GenericTypeReflector.isSuperType(superComponentType, mappedSubComponentType);
            }
            assert (mappedSubType instanceof ParameterizedType);
            ParameterizedType pMappedSubType = (ParameterizedType)mappedSubType;
            assert (pMappedSubType.getRawType() == superClass);
            ParameterizedType pSuperType = (ParameterizedType)superType;
            Type[] superTypeArgs = pSuperType.getActualTypeArguments();
            Type[] subTypeArgs = pMappedSubType.getActualTypeArguments();
            assert (superTypeArgs.length == subTypeArgs.length);
            for (int i = 0; i < superTypeArgs.length; ++i) {
                if (GenericTypeReflector.contains(superTypeArgs[i], subTypeArgs[i])) continue;
                return false;
            }
            return pSuperType.getOwnerType() == null || GenericTypeReflector.isSuperType(pSuperType.getOwnerType(), pMappedSubType.getOwnerType());
        }
        if (superType instanceof CaptureType) {
            if (superType.equals(subType)) {
                return true;
            }
            for (Type lowerBound : ((CaptureType)superType).getLowerBounds()) {
                if (!GenericTypeReflector.isSuperType(lowerBound, subType)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Type not supported: " + superType.getClass());
    }

    private static boolean isArraySupertype(Type arraySuperType, Type subType) {
        Type superTypeComponent = GenericTypeReflector.getArrayComponentType(arraySuperType);
        assert (superTypeComponent != null);
        Type subTypeComponent = GenericTypeReflector.getArrayComponentType(subType);
        if (subTypeComponent == null) {
            return false;
        }
        return GenericTypeReflector.isSuperType(superTypeComponent, subTypeComponent);
    }

    public static AnnotatedType getArrayComponentType(AnnotatedType type) {
        if (type.getType() instanceof Class) {
            Class clazz = (Class)type.getType();
            return new AnnotatedTypeImpl(clazz.getComponentType(), clazz.getAnnotations());
        }
        if (type instanceof AnnotatedArrayType) {
            AnnotatedArrayType aType = (AnnotatedArrayType)type;
            return aType.getAnnotatedGenericComponentType();
        }
        return null;
    }

    public static Type getArrayComponentType(Type type) {
        AnnotatedType componentType = GenericTypeReflector.getArrayComponentType(GenericTypeReflector.annotate(type));
        return componentType == null ? null : componentType.getType();
    }

    private static boolean contains(Type containingType, Type containedType) {
        if (containingType instanceof WildcardType) {
            WildcardType wContainingType = (WildcardType)containingType;
            for (Type upperBound : wContainingType.getUpperBounds()) {
                if (GenericTypeReflector.isSuperType(upperBound, containedType)) continue;
                return false;
            }
            for (Type lowerBound : wContainingType.getLowerBounds()) {
                if (GenericTypeReflector.isSuperType(containedType, lowerBound)) continue;
                return false;
            }
            return true;
        }
        return containingType.equals(containedType);
    }

    private static AnnotatedType[] getExactDirectSuperTypes(AnnotatedType type) {
        if (type instanceof AnnotatedParameterizedType || type != null && type.getType() instanceof Class) {
            int resultIndex;
            AnnotatedType[] result;
            Class clazz;
            if (type instanceof AnnotatedParameterizedType) {
                clazz = (Class)((ParameterizedType)type.getType()).getRawType();
            } else {
                clazz = (Class)type.getType();
                if (clazz.isArray()) {
                    return GenericTypeReflector.getArrayExactDirectSuperTypes(GenericTypeReflector.annotate(clazz));
                }
            }
            AnnotatedType[] superInterfaces = clazz.getAnnotatedInterfaces();
            AnnotatedType superClass = clazz.getAnnotatedSuperclass();
            if (superClass == null && superInterfaces.length == 0 && clazz.isInterface()) {
                return new AnnotatedType[]{new AnnotatedTypeImpl((Type)((Object)Object.class))};
            }
            if (superClass == null) {
                result = new AnnotatedType[superInterfaces.length];
                resultIndex = 0;
            } else {
                result = new AnnotatedType[superInterfaces.length + 1];
                resultIndex = 1;
                result[0] = GenericTypeReflector.mapTypeParameters(superClass, type);
            }
            for (AnnotatedType superInterface : superInterfaces) {
                result[resultIndex++] = GenericTypeReflector.mapTypeParameters(superInterface, type);
            }
            return result;
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable tv = (AnnotatedTypeVariable)type;
            return tv.getAnnotatedBounds();
        }
        if (type instanceof AnnotatedWildcardType) {
            return ((AnnotatedWildcardType)type).getAnnotatedUpperBounds();
        }
        if (type instanceof AnnotatedCaptureTypeImpl) {
            return ((AnnotatedCaptureTypeImpl)type).getAnnotatedUpperBounds();
        }
        if (type instanceof AnnotatedArrayType) {
            return GenericTypeReflector.getArrayExactDirectSuperTypes(type);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException("not implemented type: " + type);
    }

    private static AnnotatedType[] getArrayExactDirectSuperTypes(AnnotatedType arrayType) {
        AnnotatedType[] result;
        int resultIndex;
        AnnotatedType typeComponent = GenericTypeReflector.getArrayComponentType(arrayType);
        if (typeComponent != null && typeComponent.getType() instanceof Class && ((Class)typeComponent.getType()).isPrimitive()) {
            resultIndex = 0;
            result = new AnnotatedType[3];
        } else {
            AnnotatedType[] componentSupertypes = GenericTypeReflector.getExactDirectSuperTypes(typeComponent);
            result = new AnnotatedType[componentSupertypes.length + 3];
            for (resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                result[resultIndex] = AnnotatedArrayTypeImpl.createArrayType(componentSupertypes[resultIndex], new Annotation[0]);
            }
        }
        result[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Object.class));
        result[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Cloneable.class));
        result[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Serializable.class));
        return result;
    }

    public static AnnotatedType getExactReturnType(Method m, AnnotatedType declaringType) {
        return GenericTypeReflector.getReturnType(m, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactReturnType(Method m, Type declaringType) {
        return GenericTypeReflector.getExactReturnType(m, GenericTypeReflector.annotate(declaringType)).getType();
    }

    public static AnnotatedType getReturnType(Method m, AnnotatedType declaringType) {
        return GenericTypeReflector.getReturnType(m, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getReturnType(Method m, Type declaringType) {
        return GenericTypeReflector.getReturnType(m, GenericTypeReflector.annotate(declaringType)).getType();
    }

    private static AnnotatedType getReturnType(Method m, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType returnType = m.getAnnotatedReturnType();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), m.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The method " + m + " is not a member of type " + declaringType);
        }
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType, mappingMode);
    }

    public static AnnotatedType getExactFieldType(Field f, AnnotatedType declaringType) {
        return GenericTypeReflector.getFieldType(f, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactFieldType(Field f, Type type) {
        return GenericTypeReflector.getExactFieldType(f, GenericTypeReflector.annotate(type)).getType();
    }

    public static AnnotatedType getFieldType(Field f, AnnotatedType declaringType) {
        return GenericTypeReflector.getFieldType(f, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getFieldType(Field f, Type type) {
        return GenericTypeReflector.getFieldType(f, GenericTypeReflector.annotate(type)).getType();
    }

    private static AnnotatedType getFieldType(Field f, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType returnType = f.getAnnotatedType();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), f.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The field " + f + " is not a member of type " + declaringType);
        }
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType, mappingMode);
    }

    public static AnnotatedType[] getExactParameterTypes(Executable exe, AnnotatedType declaringType) {
        return GenericTypeReflector.getParameterTypes(exe, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type[] getExactParameterTypes(Executable exe, Type declaringType) {
        return (Type[])Arrays.stream(GenericTypeReflector.getExactParameterTypes(exe, GenericTypeReflector.annotate(declaringType))).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    public static AnnotatedType[] getParameterTypes(Executable exe, AnnotatedType declaringType) {
        return GenericTypeReflector.getParameterTypes(exe, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type[] getParameterTypes(Executable exe, Type declaringType) {
        return (Type[])Arrays.stream(GenericTypeReflector.getParameterTypes(exe, GenericTypeReflector.annotate(declaringType))).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    private static AnnotatedType[] getParameterTypes(Executable exe, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType[] parameterTypes = exe.getAnnotatedParameterTypes();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), exe.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The method/constructor " + exe + " is not a member of type " + declaringType);
        }
        AnnotatedType[] result = new AnnotatedType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result[i] = GenericTypeReflector.mapTypeParameters(parameterTypes[i], exactDeclaringType, mappingMode);
        }
        return result;
    }

    public static AnnotatedType capture(AnnotatedType type) {
        if (type instanceof AnnotatedParameterizedType) {
            return GenericTypeReflector.capture((AnnotatedParameterizedType)type);
        }
        return type;
    }

    public static AnnotatedParameterizedType capture(AnnotatedParameterizedType type) {
        VarMap varMap = new VarMap();
        ArrayList<AnnotatedCaptureTypeImpl> toInit = new ArrayList<AnnotatedCaptureTypeImpl>();
        Class clazz = (Class)((ParameterizedType)type.getType()).getRawType();
        AnnotatedType[] arguments = type.getAnnotatedActualTypeArguments();
        TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
        AnnotatedType[] capturedArguments = new AnnotatedType[arguments.length];
        assert (arguments.length == vars.length);
        for (int i = 0; i < arguments.length; ++i) {
            AnnotatedType argument = arguments[i];
            if (argument instanceof AnnotatedWildcardType) {
                AnnotatedCaptureTypeImpl captured = new AnnotatedCaptureTypeImpl((AnnotatedWildcardType)argument, new AnnotatedTypeVariableImpl(vars[i]));
                argument = captured;
                toInit.add(captured);
            }
            capturedArguments[i] = argument;
            varMap.add(vars[i], argument);
        }
        for (AnnotatedCaptureTypeImpl captured : toInit) {
            captured.init(varMap);
        }
        ParameterizedType inner = (ParameterizedType)type.getType();
        AnnotatedType ownerType = inner.getOwnerType() == null ? null : GenericTypeReflector.capture(GenericTypeReflector.annotate(inner.getOwnerType()));
        Type[] rawArgs = (Type[])Arrays.stream(capturedArguments).map(AnnotatedType::getType).toArray(Type[]::new);
        ParameterizedTypeImpl nn = new ParameterizedTypeImpl(clazz, rawArgs, ownerType == null ? null : ownerType.getType());
        return new AnnotatedParameterizedTypeImpl(nn, type.getAnnotations(), capturedArguments);
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? GenericTypeReflector.getTypeName(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return type.toString();
    }

    public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type) {
        LinkedHashSet result = new LinkedHashSet();
        GenericTypeReflector.buildUpperBoundClassAndInterfaces(type, result);
        return new ArrayList(result);
    }

    public static AnnotatedType annotate(Type type) {
        return GenericTypeReflector.annotate(type, new HashMap<CaptureCacheKey, AnnotatedType>());
    }

    public static AnnotatedType annotate(Type type, Annotation[] annotations) {
        return GenericTypeReflector.updateAnnotations(GenericTypeReflector.annotate(type), annotations);
    }

    private static AnnotatedType annotate(Type type, Map<CaptureCacheKey, AnnotatedType> cache) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            AnnotatedType[] params = new AnnotatedType[parameterized.getActualTypeArguments().length];
            for (int i = 0; i < params.length; ++i) {
                AnnotatedType param = GenericTypeReflector.annotate(parameterized.getActualTypeArguments()[i], cache);
                params[i] = GenericTypeReflector.updateAnnotations(param, GenericTypeReflector.erase(type).getTypeParameters()[i].getAnnotations());
            }
            return new AnnotatedParameterizedTypeImpl(parameterized, GenericTypeReflector.erase(type).getAnnotations(), params);
        }
        if (type instanceof CaptureType) {
            CaptureCacheKey key = new CaptureCacheKey((CaptureType)type);
            if (cache.containsKey(key)) {
                return cache.get(key);
            }
            CaptureType capture = (CaptureType)type;
            AnnotatedCaptureTypeImpl annotatedCapture = new AnnotatedCaptureTypeImpl((AnnotatedWildcardType)GenericTypeReflector.annotate((Type)capture.getWildcardType(), cache), (AnnotatedTypeVariable)GenericTypeReflector.annotate(capture.getTypeVariable(), cache), null);
            cache.put(new CaptureCacheKey(capture), annotatedCapture);
            AnnotatedType[] upperBounds = (AnnotatedType[])Arrays.stream(capture.getUpperBounds()).map(bound -> GenericTypeReflector.annotate(bound, cache)).toArray(AnnotatedType[]::new);
            annotatedCapture.setAnnotatedUpperBounds(upperBounds);
            return annotatedCapture;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            AnnotatedType[] lowerBounds = (AnnotatedType[])Arrays.stream(wildcard.getLowerBounds()).map(bound -> GenericTypeReflector.annotate(bound, cache)).toArray(AnnotatedType[]::new);
            AnnotatedType[] upperBounds = (AnnotatedType[])Arrays.stream(wildcard.getUpperBounds()).map(bound -> GenericTypeReflector.annotate(bound, cache)).toArray(AnnotatedType[]::new);
            return new AnnotatedWildcardTypeImpl(wildcard, GenericTypeReflector.erase(type).getAnnotations(), lowerBounds, upperBounds);
        }
        if (type instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genArray = (GenericArrayType)type;
            return new AnnotatedArrayTypeImpl(genArray, new Annotation[0], GenericTypeReflector.annotate(genArray.getGenericComponentType()));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                Class<?> componentClass = clazz.getComponentType();
                return AnnotatedArrayTypeImpl.createArrayType(new AnnotatedTypeImpl(componentClass, componentClass.getAnnotations()), new Annotation[0]);
            }
            return new AnnotatedTypeImpl(clazz, clazz.getAnnotations());
        }
        throw new IllegalArgumentException("Unrecognized type: " + type.getTypeName());
    }

    public static AnnotatedType replaceAnnotations(AnnotatedType original, Annotation[] annotations) {
        if (original instanceof AnnotatedParameterizedType) {
            return new AnnotatedParameterizedTypeImpl((ParameterizedType)original.getType(), annotations, ((AnnotatedParameterizedType)original).getAnnotatedActualTypeArguments());
        }
        if (original instanceof AnnotatedCaptureType) {
            return new AnnotatedCaptureTypeImpl(((AnnotatedCaptureType)original).getAnnotatedWildcardType(), ((AnnotatedCaptureType)original).getAnnotatedTypeVariable(), ((AnnotatedCaptureType)original).getAnnotatedUpperBounds(), annotations);
        }
        if (original instanceof AnnotatedWildcardType) {
            return new AnnotatedWildcardTypeImpl((WildcardType)original.getType(), annotations, ((AnnotatedWildcardType)original).getAnnotatedLowerBounds(), ((AnnotatedWildcardType)original).getAnnotatedUpperBounds());
        }
        if (original instanceof AnnotatedTypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)original.getType(), annotations);
        }
        if (original instanceof AnnotatedArrayType) {
            return new AnnotatedArrayTypeImpl(original.getType(), annotations, ((AnnotatedArrayType)original).getAnnotatedGenericComponentType());
        }
        return new AnnotatedTypeImpl(original.getType(), annotations);
    }

    public static AnnotatedType updateAnnotations(AnnotatedType original, Annotation[] annotations) {
        if (annotations == null || annotations.length == 0 || Arrays.equals(original.getAnnotations(), annotations)) {
            return original;
        }
        return GenericTypeReflector.replaceAnnotations(original, GenericTypeReflector.merge(original.getAnnotations(), annotations));
    }

    public static AnnotatedParameterizedType replaceParameters(AnnotatedParameterizedType type, AnnotatedType[] typeParameters) {
        Type[] rawArguments = (Type[])Arrays.stream(typeParameters).map(AnnotatedType::getType).toArray(Type[]::new);
        ParameterizedType rawType = (ParameterizedType)TypeFactory.parameterizedClass(GenericTypeReflector.erase(type.getType()), rawArguments);
        return new AnnotatedParameterizedTypeImpl(rawType, type.getAnnotations(), typeParameters);
    }

    public static AnnotatedType clone(AnnotatedType type) {
        return GenericTypeReflector.replaceAnnotations(type, type.getAnnotations());
    }

    public static Annotation[] merge(Annotation[] ... annotations) {
        return Arrays.stream(annotations).reduce((acc, arr) -> (Annotation[])Stream.concat(Arrays.stream(acc), Arrays.stream(arr)).distinct().toArray(Annotation[]::new)).orElse(new Annotation[0]);
    }

    static boolean typeArraysEqual(AnnotatedType[] t1, AnnotatedType[] t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null) {
            return false;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t1[i].getType().equals(t2[i].getType()) && Arrays.equals(t1[i].getAnnotations(), t2[i].getAnnotations())) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(AnnotatedType ... types) {
        OptionalInt typeHash = Arrays.stream(types).mapToInt(t -> t.getType().hashCode()).reduce((x, y) -> x ^ y);
        OptionalInt annotationHash = Arrays.stream(types).flatMap(t -> Arrays.stream(t.getAnnotations())).mapToInt(Annotation::hashCode).reduce((x, y) -> x ^ y);
        return 31 * typeHash.orElse(0) ^ annotationHash.orElse(0);
    }

    public static boolean equals(AnnotatedType t1, AnnotatedType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        t1 = t1 instanceof AnnotatedTypeImpl ? t1 : GenericTypeReflector.clone(t1);
        t2 = t2 instanceof AnnotatedTypeImpl ? t2 : GenericTypeReflector.clone(t2);
        return t1.equals(t2);
    }

    private static void buildUpperBoundClassAndInterfaces(Type type, Set<Class<?>> result) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            result.add(GenericTypeReflector.erase(type));
            return;
        }
        for (AnnotatedType superType : GenericTypeReflector.getExactDirectSuperTypes(GenericTypeReflector.annotate(type))) {
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(superType.getType(), result);
        }
    }

    private static class CaptureCacheKey {
        CaptureType capture;

        CaptureCacheKey(CaptureType capture) {
            this.capture = capture;
        }

        public int hashCode() {
            return this.capture.getWildcardType().hashCode() + this.capture.getTypeVariable().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CaptureCacheKey)) {
                return false;
            }
            CaptureType other = ((CaptureCacheKey)obj).capture;
            if (!this.capture.getWildcardType().equals(other.getWildcardType()) || !this.capture.getTypeVariable().equals(other.getTypeVariable())) {
                return false;
            }
            return Arrays.equals(this.capture.getUpperBounds(), other.getUpperBounds());
        }
    }
}

