/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

class GenericArrayTypeImpl
implements GenericArrayType {
    private Type componentType;

    GenericArrayTypeImpl(Type componentType) {
        this.componentType = componentType;
    }

    static Class<?> createArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    static Type createArrayType(Type componentType) {
        if (componentType instanceof Class) {
            return GenericArrayTypeImpl.createArrayType((Class)componentType);
        }
        return new GenericArrayTypeImpl(componentType);
    }

    @Override
    public Type getGenericComponentType() {
        return this.componentType;
    }

    public boolean equals(Object obj) {
        return obj instanceof GenericArrayType && this.componentType.equals(((GenericArrayType)obj).getGenericComponentType());
    }

    public int hashCode() {
        return this.componentType.hashCode() * 7;
    }

    public String toString() {
        return this.componentType + "[]";
    }
}

