/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

class AnnotatedTypeVariableImpl
extends AnnotatedTypeImpl
implements AnnotatedTypeVariable {
    private AnnotatedType[] annotatedBounds;

    AnnotatedTypeVariableImpl(TypeVariable<?> type) {
        this(type, type.getAnnotations());
    }

    AnnotatedTypeVariableImpl(TypeVariable<?> type, Annotation[] annotations) {
        this(type, annotations, type.getAnnotatedBounds());
    }

    AnnotatedTypeVariableImpl(TypeVariable<?> type, Annotation[] annotations, AnnotatedType[] annotatedBounds) {
        super(type, annotations);
        if (annotatedBounds == null || annotatedBounds.length == 0) {
            annotatedBounds = new AnnotatedType[]{};
        }
        AnnotatedTypeVariableImpl.validateBounds(type, annotatedBounds);
        this.annotatedBounds = annotatedBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        return this.annotatedBounds;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedTypeVariable) || !super.equals(other)) {
            return false;
        }
        return GenericTypeReflector.typeArraysEqual(this.annotatedBounds, ((AnnotatedTypeVariable)other).getAnnotatedBounds());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ GenericTypeReflector.hashCode(this.annotatedBounds);
    }

    @Override
    public String toString() {
        return this.annotationsString() + ((TypeVariable)this.type).getName() + " extends " + this.typesString(this.annotatedBounds);
    }

    private static void validateBounds(TypeVariable type, AnnotatedType[] bounds) {
        if (type.getBounds().length != bounds.length) {
            throw new IllegalArgumentException("Incompatible bounds " + Arrays.toString(bounds) + " for type " + type.toString());
        }
        for (int i = 0; i < type.getBounds().length; ++i) {
            if (GenericTypeReflector.erase(type.getBounds()[i]) == GenericTypeReflector.erase(bounds[i].getType())) continue;
            throw new IllegalArgumentException("Bound " + bounds[i].getType() + " incompatible with " + type.getBounds()[i] + " in type " + type.toString());
        }
    }
}

