/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.CaptureTypeImpl;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.VarMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AnnotatedCaptureTypeImpl
implements AnnotatedCaptureType {
    private final AnnotatedWildcardType wildcard;
    private final AnnotatedTypeVariable variable;
    private final AnnotatedType[] lowerBounds;
    private AnnotatedType[] upperBounds;
    private CaptureType type;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Annotation[] declaredAnnotations;

    public AnnotatedCaptureTypeImpl(AnnotatedWildcardType wildcard, AnnotatedTypeVariable variable, AnnotatedType[] upperBounds, Annotation[] annotations) {
        this(wildcard, variable, upperBounds);
        this.annotations = Arrays.stream(annotations).collect(Collectors.toMap(Object::getClass, annotation -> annotation));
    }

    public AnnotatedCaptureTypeImpl(AnnotatedWildcardType wildcard, AnnotatedTypeVariable variable, AnnotatedType[] upperBounds) {
        this(wildcard, variable);
        this.upperBounds = upperBounds;
    }

    public AnnotatedCaptureTypeImpl(AnnotatedWildcardType wildcard, AnnotatedTypeVariable variable) {
        this.wildcard = wildcard;
        this.variable = variable;
        this.lowerBounds = wildcard.getAnnotatedLowerBounds();
        this.type = new CaptureTypeImpl((WildcardType)wildcard.getType(), (TypeVariable)variable.getType());
        this.annotations = Stream.concat(Arrays.stream(wildcard.getAnnotations()), Arrays.stream(variable.getAnnotations())).collect(Collectors.toMap(Object::getClass, annotation -> annotation));
        this.declaredAnnotations = (Annotation[])Stream.concat(Arrays.stream(wildcard.getDeclaredAnnotations()), Arrays.stream(variable.getDeclaredAnnotations())).toArray(Annotation[]::new);
    }

    void init(VarMap varMap) {
        ArrayList<AnnotatedType> upperBoundsList = new ArrayList<AnnotatedType>();
        upperBoundsList.addAll(Arrays.asList(varMap.map(this.variable.getAnnotatedBounds())));
        List<AnnotatedType> wildcardUpperBounds = Arrays.asList(this.wildcard.getAnnotatedUpperBounds());
        if (wildcardUpperBounds.size() > 0 && wildcardUpperBounds.get(0).getType() == Object.class) {
            upperBoundsList.addAll(wildcardUpperBounds.subList(1, wildcardUpperBounds.size()));
        } else {
            upperBoundsList.addAll(wildcardUpperBounds);
        }
        this.upperBounds = new AnnotatedType[upperBoundsList.size()];
        upperBoundsList.toArray(this.upperBounds);
        ((CaptureTypeImpl)this.type).init(varMap);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        assert (this.upperBounds != null);
        return (AnnotatedType[])this.upperBounds.clone();
    }

    @Override
    public void setAnnotatedUpperBounds(AnnotatedType[] upperBounds) {
        this.upperBounds = upperBounds;
        this.type.setUpperBounds((Type[])Arrays.stream(upperBounds).map(AnnotatedType::getType).toArray(Type[]::new));
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return (AnnotatedType[])this.lowerBounds.clone();
    }

    @Override
    public AnnotatedTypeVariable getAnnotatedTypeVariable() {
        return this.variable;
    }

    @Override
    public AnnotatedWildcardType getAnnotatedWildcardType() {
        return this.wildcard;
    }

    public int hashCode() {
        return this.wildcard.hashCode() ^ this.variable.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedCaptureType)) {
            return false;
        }
        AnnotatedCaptureType that = (AnnotatedCaptureType)other;
        if (!this.wildcard.equals(that.getAnnotatedWildcardType()) || !this.variable.equals(that.getAnnotatedTypeVariable())) {
            return false;
        }
        return GenericTypeReflector.typeArraysEqual(this.upperBounds, that.getAnnotatedUpperBounds());
    }
}

