/*
 * Decompiled with CFR 0.152.
 */
package org.crygier.graphql;

import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;

public class JpaDataFetcher
implements DataFetcher {
    protected EntityManager entityManager;
    protected EntityType<?> entityType;

    public JpaDataFetcher(EntityManager entityManager, EntityType<?> entityType) {
        this.entityManager = entityManager;
        this.entityType = entityType;
    }

    public Object get(DataFetchingEnvironment environment) {
        return this.getQuery(environment, (Field)environment.getFields().iterator().next()).getResultList();
    }

    protected TypedQuery getQuery(DataFetchingEnvironment environment, Field field) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.entityType.getJavaType());
        Root root = query.from(this.entityType);
        ArrayList arguments = new ArrayList();
        field.getSelectionSet().getSelections().forEach(selection -> {
            Field selectedField;
            if (selection instanceof Field && !"__typename".equals((selectedField = (Field)selection).getName())) {
                SingularAttribute attribute;
                Path fieldPath = root.get(selectedField.getName());
                Optional<Argument> orderByArgument = selectedField.getArguments().stream().filter(it -> "orderBy".equals(it.getName())).findFirst();
                if (orderByArgument.isPresent()) {
                    if ("DESC".equals(((EnumValue)orderByArgument.get().getValue()).getName())) {
                        query.orderBy(new Order[]{cb.desc((Expression)fieldPath)});
                    } else {
                        query.orderBy(new Order[]{cb.asc((Expression)fieldPath)});
                    }
                }
                arguments.addAll(selectedField.getArguments().stream().filter(it -> !"orderBy".equals(it.getName())).map(it -> new Argument(selectedField.getName() + "." + it.getName(), it.getValue())).collect(Collectors.toList()));
                if (fieldPath.getModel() instanceof SingularAttribute && ((attribute = (SingularAttribute)fieldPath.getModel()).getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                    root.fetch(selectedField.getName());
                }
            }
        });
        arguments.addAll(field.getArguments());
        List<Predicate> predicates = arguments.stream().map(it -> this.getPredicate(cb, root, environment, (Argument)it)).collect(Collectors.toList());
        query.where(predicates.toArray(new Predicate[predicates.size()]));
        return this.entityManager.createQuery(query.distinct(true));
    }

    private Predicate getPredicate(CriteriaBuilder cb, Root root, DataFetchingEnvironment environment, Argument argument) {
        Path path = null;
        if (!argument.getName().contains(".")) {
            Attribute argumentEntityAttribute = this.getAttribute(environment, argument);
            if (argumentEntityAttribute instanceof PluralAttribute) {
                Join join = root.join(argument.getName());
                return join.in(new Object[]{this.convertValue(environment, argument, argument.getValue())});
            }
            path = root.get(argument.getName());
            return cb.equal((Expression)path, this.convertValue(environment, argument, argument.getValue()));
        }
        List<String> parts = Arrays.asList(argument.getName().split("\\."));
        for (String part : parts) {
            if (path == null) {
                path = root.get(part);
                continue;
            }
            path = path.get(part);
        }
        return cb.equal((Expression)path, this.convertValue(environment, argument, argument.getValue()));
    }

    protected Object convertValue(DataFetchingEnvironment environment, Argument argument, Value value) {
        if (value instanceof StringValue) {
            Object convertedValue = environment.getArgument(argument.getName());
            if (convertedValue != null) {
                return convertedValue;
            }
            return ((StringValue)value).getValue();
        }
        if (value instanceof VariableReference) {
            return environment.getArguments().get(((VariableReference)value).getName());
        }
        if (value instanceof ArrayValue) {
            return ((ArrayValue)value).getValues().stream().map(it -> this.convertValue(environment, argument, (Value)it)).collect(Collectors.toList());
        }
        if (value instanceof EnumValue) {
            Class enumType = this.getJavaType(environment, argument);
            return Enum.valueOf(enumType, ((EnumValue)value).getName());
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        return value.toString();
    }

    private Class getJavaType(DataFetchingEnvironment environment, Argument argument) {
        Attribute argumentEntityAttribute = this.getAttribute(environment, argument);
        if (argumentEntityAttribute instanceof PluralAttribute) {
            return ((PluralAttribute)argumentEntityAttribute).getElementType().getJavaType();
        }
        return argumentEntityAttribute.getJavaType();
    }

    private Attribute getAttribute(DataFetchingEnvironment environment, Argument argument) {
        GraphQLObjectType objectType = this.getObjectType(environment, argument);
        EntityType entityType = this.getEntityType(objectType);
        return entityType.getAttribute(argument.getName());
    }

    private EntityType getEntityType(GraphQLObjectType objectType) {
        return this.entityManager.getMetamodel().getEntities().stream().filter(it -> it.getName().equals(objectType.getName())).findFirst().get();
    }

    private GraphQLObjectType getObjectType(DataFetchingEnvironment environment, Argument argument) {
        GraphQLOutputType outputType = environment.getFieldType();
        if (outputType instanceof GraphQLList) {
            outputType = ((GraphQLList)outputType).getWrappedType();
        }
        if (outputType instanceof GraphQLObjectType) {
            return (GraphQLObjectType)outputType;
        }
        return null;
    }
}

