/*
 * Decompiled with CFR 0.152.
 */
package org.crygier.graphql;

import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScalars {
    static final Logger log = LoggerFactory.getLogger(JavaScalars.class);
    public static GraphQLScalarType GraphQLLocalDateTime = new GraphQLScalarType("LocalDateTime", "Date type", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToLocalDateTime((String)input);
            }
            if (input instanceof LocalDateTime) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDateTime((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDateTime(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDateTime(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDateTime(value.longValue());
            }
            return null;
        }

        private LocalDateTime parseLongToLocalDateTime(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId());
        }

        private LocalDateTime parseStringToLocalDateTime(String input) {
            try {
                return LocalDateTime.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    });
    public static GraphQLScalarType GraphQLLocalDate = new GraphQLScalarType("LocalDate", "Date type", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToLocalDate((String)input);
            }
            if (input instanceof LocalDate) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDate((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDate(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDate(value.longValue());
            }
            return null;
        }

        private LocalDate parseLongToLocalDate(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId()).toLocalDate();
        }

        private LocalDate parseStringToLocalDate(String input) {
            try {
                return LocalDate.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    });
    public static GraphQLScalarType GraphQLDate = new GraphQLScalarType("Date", "Date type", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToDate((String)input);
            }
            if (input instanceof Date) {
                return input;
            }
            if (input instanceof Long) {
                return new Date((Long)input);
            }
            if (input instanceof Integer) {
                return new Date(((Integer)input).longValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return new Date(value.longValue());
            }
            return null;
        }

        private Date parseStringToDate(String input) {
            try {
                return DateFormat.getInstance().parse(input);
            }
            catch (ParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    });
    public static GraphQLScalarType GraphQLUUID = new GraphQLScalarType("UUID", "UUID type", new Coercing(){

        public Object serialize(Object input) {
            if (input instanceof UUID) {
                return input;
            }
            return null;
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return this.parseStringToUUID((String)input);
            }
            return null;
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToUUID(((StringValue)input).getValue());
            }
            return null;
        }

        private UUID parseStringToUUID(String input) {
            try {
                return UUID.fromString(input);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to parse UUID from input: " + input, (Throwable)e);
                return null;
            }
        }
    });
}

