/*
 * Decompiled with CFR 0.152.
 */
package org.crygier.graphql;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.crygier.graphql.ExtendedJpaDataFetcher;
import org.crygier.graphql.IdentityCoercing;
import org.crygier.graphql.JavaScalars;
import org.crygier.graphql.JpaDataFetcher;
import org.crygier.graphql.annotation.GraphQLIgnore;
import org.crygier.graphql.annotation.SchemaDocumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaBuilder
extends GraphQLSchema.Builder {
    public static final String PAGINATION_REQUEST_PARAM_NAME = "paginationRequest";
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaBuilder.class);
    private final EntityManager entityManager;
    private final Map<Class, GraphQLType> classCache = new HashMap<Class, GraphQLType>();
    private final Map<EntityType, GraphQLObjectType> entityCache = new HashMap<EntityType, GraphQLObjectType>();
    private static final GraphQLArgument paginationArgument = GraphQLArgument.newArgument().name("paginationRequest").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("PaginationObject").description("Query object for Pagination Requests, specifying the requested page, and that page's size.\n\nNOTE: 'page' parameter is 1-indexed, NOT 0-indexed.\n\nExample: paginationRequest { page: 1, size: 20 }").field(GraphQLInputObjectField.newInputObjectField().name("page").description("Which page should be returned, starting with 1 (1-indexed)").type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("size").description("How many results should this page contain").type((GraphQLInputType)Scalars.GraphQLInt).build()).build()).build();
    private static final GraphQLEnumType orderByDirectionEnum = GraphQLEnumType.newEnum().name("OrderByDirection").description("Describes the direction (Ascending / Descending) to sort a field.").value("ASC", (Object)0, "Ascending").value("DESC", (Object)1, "Descending").build();

    public GraphQLSchemaBuilder(EntityManager entityManager) {
        this.entityManager = entityManager;
        super.query(this.getQueryType());
    }

    @Deprecated
    public GraphQLSchema getGraphQLSchema() {
        return super.build();
    }

    GraphQLObjectType getQueryType() {
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name("QueryType_JPA").description("All encompassing schema for this JPA environment");
        queryType.fields(this.entityManager.getMetamodel().getEntities().stream().filter(this::isNotIgnored).map(this::getQueryFieldDefinition).collect(Collectors.toList()));
        queryType.fields(this.entityManager.getMetamodel().getEntities().stream().filter(this::isNotIgnored).map(this::getQueryFieldPageableDefinition).collect(Collectors.toList()));
        return queryType.build();
    }

    GraphQLFieldDefinition getQueryFieldDefinition(EntityType<?> entityType) {
        return GraphQLFieldDefinition.newFieldDefinition().name(entityType.getName()).description(this.getSchemaDocumentation(entityType.getJavaType())).type((GraphQLOutputType)new GraphQLList((GraphQLType)this.getObjectType(entityType))).dataFetcher((DataFetcher)new JpaDataFetcher(this.entityManager, entityType)).argument(entityType.getAttributes().stream().filter(this::isValidInput).filter(this::isNotIgnored).flatMap(this::getArgument).collect(Collectors.toList())).build();
    }

    private GraphQLFieldDefinition getQueryFieldPageableDefinition(EntityType<?> entityType) {
        GraphQLObjectType pageType = GraphQLObjectType.newObject().name(entityType.getName() + "Connection").description("'Connection' response wrapper object for " + entityType.getName() + ".  When pagination or aggregation is requested, this object will be returned with metadata about the query.").field(GraphQLFieldDefinition.newFieldDefinition().name("totalPages").description("Total number of pages calculated on the database for this pageSize.").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("totalElements").description("Total number of results on the database for this query.").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("content").description("The actual object results").type((GraphQLOutputType)new GraphQLList((GraphQLType)this.getObjectType(entityType))).build()).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(entityType.getName() + "Connection").description("'Connection' request wrapper object for " + entityType.getName() + ".  Use this object in a query to request things like pagination or aggregation in an argument.  Use the 'content' field to request actual fields ").type((GraphQLOutputType)pageType).dataFetcher((DataFetcher)new ExtendedJpaDataFetcher(this.entityManager, entityType)).argument(paginationArgument).build();
    }

    private Stream<GraphQLArgument> getArgument(Attribute attribute) {
        return this.getAttributeType(attribute).filter(type -> type instanceof GraphQLInputType).filter(type -> attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED && type instanceof GraphQLScalarType).map(type -> {
            String name = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? type.getName() : attribute.getName();
            return GraphQLArgument.newArgument().name(name).type((GraphQLInputType)type).build();
        });
    }

    GraphQLObjectType getObjectType(EntityType<?> entityType) {
        if (this.entityCache.containsKey(entityType)) {
            return this.entityCache.get(entityType);
        }
        GraphQLObjectType answer = GraphQLObjectType.newObject().name(entityType.getName()).description(this.getSchemaDocumentation(entityType.getJavaType())).fields(entityType.getAttributes().stream().filter(this::isNotIgnored).flatMap(this::getObjectField).collect(Collectors.toList())).build();
        this.entityCache.put(entityType, answer);
        return answer;
    }

    private Stream<GraphQLFieldDefinition> getObjectField(Attribute attribute) {
        return this.getAttributeType(attribute).filter(type -> type instanceof GraphQLOutputType).map(type -> {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            arguments.add(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)orderByDirectionEnum).build());
            if (attribute instanceof SingularAttribute && attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC) {
                ManagedType foreignType = (ManagedType)((SingularAttribute)attribute).getType();
                Stream<Attribute> attributes = this.findBasicAttributes(foreignType.getAttributes());
                attributes.forEach(it -> arguments.add(GraphQLArgument.newArgument().name(it.getName()).type((GraphQLInputType)this.getAttributeType((Attribute)it).findFirst().get()).build()));
            }
            String name = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? type.getName() : attribute.getName();
            return GraphQLFieldDefinition.newFieldDefinition().name(name).description(this.getSchemaDocumentation(attribute.getJavaMember())).type((GraphQLOutputType)type).argument(arguments).build();
        });
    }

    private Stream<Attribute> findBasicAttributes(Collection<Attribute> attributes) {
        return attributes.stream().filter(this::isNotIgnored).filter(it -> it.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC);
    }

    private GraphQLType getBasicAttributeType(Class javaType) {
        if (String.class.isAssignableFrom(javaType)) {
            return Scalars.GraphQLString;
        }
        if (UUID.class.isAssignableFrom(javaType)) {
            return JavaScalars.GraphQLUUID;
        }
        if (Integer.class.isAssignableFrom(javaType) || Integer.TYPE.isAssignableFrom(javaType)) {
            return Scalars.GraphQLInt;
        }
        if (Short.class.isAssignableFrom(javaType) || Short.TYPE.isAssignableFrom(javaType)) {
            return Scalars.GraphQLShort;
        }
        if (Float.class.isAssignableFrom(javaType) || Float.TYPE.isAssignableFrom(javaType) || Double.class.isAssignableFrom(javaType) || Double.TYPE.isAssignableFrom(javaType)) {
            return Scalars.GraphQLFloat;
        }
        if (Long.class.isAssignableFrom(javaType) || Long.TYPE.isAssignableFrom(javaType)) {
            return Scalars.GraphQLLong;
        }
        if (Boolean.class.isAssignableFrom(javaType) || Boolean.TYPE.isAssignableFrom(javaType)) {
            return Scalars.GraphQLBoolean;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return JavaScalars.GraphQLDate;
        }
        if (LocalDateTime.class.isAssignableFrom(javaType)) {
            return JavaScalars.GraphQLLocalDateTime;
        }
        if (LocalDate.class.isAssignableFrom(javaType)) {
            return JavaScalars.GraphQLLocalDate;
        }
        if (javaType.isEnum()) {
            return this.getTypeFromJavaType(javaType);
        }
        if (BigDecimal.class.isAssignableFrom(javaType)) {
            return Scalars.GraphQLBigDecimal;
        }
        throw new UnsupportedOperationException("Class could not be mapped to GraphQL: '" + javaType.getClass().getTypeName() + "'");
    }

    private Stream<GraphQLType> getAttributeType(Attribute attribute) {
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC) {
            try {
                return Stream.of(this.getBasicAttributeType(attribute.getJavaType()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        } else {
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY) {
                EntityType foreignType = (EntityType)((PluralAttribute)attribute).getElementType();
                return Stream.of(new GraphQLList((GraphQLType)new GraphQLTypeReference(foreignType.getName())));
            }
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                EntityType foreignType = (EntityType)((SingularAttribute)attribute).getType();
                return Stream.of(new GraphQLTypeReference(foreignType.getName()));
            }
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                Type foreignType = ((PluralAttribute)attribute).getElementType();
                return Stream.of(new GraphQLList(this.getTypeFromJavaType(foreignType.getJavaType())));
            }
            if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                EmbeddableType embeddableType = (EmbeddableType)((SingularAttribute)attribute).getType();
                Stream s = embeddableType.getAttributes().stream();
                return s.flatMap(this::getAttributeType);
            }
        }
        String declaringType = attribute.getDeclaringType().getJavaType().getName();
        String declaringMember = attribute.getJavaMember().getName();
        throw new UnsupportedOperationException("Attribute could not be mapped to GraphQL: field '" + declaringMember + "' of entity class '" + declaringType + "'");
    }

    private boolean isValidInput(Attribute attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
    }

    private String getSchemaDocumentation(Member member) {
        if (member instanceof AnnotatedElement) {
            return this.getSchemaDocumentation((AnnotatedElement)((Object)member));
        }
        return null;
    }

    private String getSchemaDocumentation(AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            SchemaDocumentation schemaDocumentation = annotatedElement.getAnnotation(SchemaDocumentation.class);
            return schemaDocumentation != null ? schemaDocumentation.value() : null;
        }
        return null;
    }

    private boolean isNotIgnored(Attribute attribute) {
        return this.isNotIgnored(attribute.getJavaMember()) && this.isNotIgnored(attribute.getJavaType());
    }

    private boolean isNotIgnored(EntityType entityType) {
        return this.isNotIgnored(entityType.getJavaType());
    }

    private boolean isNotIgnored(Member member) {
        return member instanceof AnnotatedElement && this.isNotIgnored((AnnotatedElement)((Object)member));
    }

    private boolean isNotIgnored(AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            GraphQLIgnore schemaDocumentation = annotatedElement.getAnnotation(GraphQLIgnore.class);
            return schemaDocumentation == null;
        }
        return false;
    }

    private GraphQLType getTypeFromJavaType(Class clazz) {
        if (clazz.isEnum()) {
            if (this.classCache.containsKey(clazz)) {
                return this.classCache.get(clazz);
            }
            GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(clazz.getSimpleName());
            int ordinal = 0;
            for (Enum enumValue : (Enum[])clazz.getEnumConstants()) {
                enumBuilder.value(enumValue.name(), (Object)ordinal++);
            }
            GraphQLEnumType answer = enumBuilder.build();
            this.setIdentityCoercing((GraphQLType)answer);
            this.classCache.put(clazz, (GraphQLType)answer);
            return answer;
        }
        return this.getBasicAttributeType(clazz);
    }

    private void setIdentityCoercing(GraphQLType type) {
        try {
            Field coercing = type.getClass().getDeclaredField("coercing");
            coercing.setAccessible(true);
            coercing.set(type, new IdentityCoercing());
        }
        catch (Exception e) {
            log.error("Unable to set coercing for " + type, (Throwable)e);
        }
    }
}

