/*
 * Decompiled with CFR 0.152.
 */
package org.crygier.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.crygier.graphql.GraphQLSchemaBuilder;

public class GraphQLExecutor {
    @Resource
    private EntityManager entityManager;
    private GraphQL graphQL;
    private GraphQLSchema graphQLSchema;
    private GraphQLSchema.Builder builder;

    protected GraphQLExecutor() {
        this.createGraphQL();
    }

    public GraphQLExecutor(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.createGraphQL();
    }

    @PostConstruct
    protected synchronized void createGraphQL() {
        if (this.entityManager != null) {
            if (this.builder == null) {
                this.builder = new GraphQLSchemaBuilder(this.entityManager);
            }
            this.graphQLSchema = this.builder.build();
            this.graphQL = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema).build();
        }
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    @Transactional
    public ExecutionResult execute(String query) {
        return this.graphQL.execute(query);
    }

    @Transactional
    public ExecutionResult execute(String query, Map<String, Object> arguments) {
        if (arguments == null) {
            return this.graphQL.execute(query);
        }
        return this.graphQL.execute(ExecutionInput.newExecutionInput().query(query).variables(arguments).build());
    }

    public GraphQLSchema.Builder getBuilder() {
        return this.builder;
    }

    public GraphQLSchema getSchema() {
        return this.graphQLSchema;
    }

    public GraphQLExecutor updateSchema(GraphQLSchema.Builder builder) {
        this.builder = builder;
        this.createGraphQL();
        return this;
    }
}

