/*
 * Decompiled with CFR 0.152.
 */
package org.crygier.graphql;

import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.IntValue;
import graphql.language.ObjectValue;
import graphql.schema.DataFetchingEnvironment;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.crygier.graphql.JpaDataFetcher;

public class ExtendedJpaDataFetcher
extends JpaDataFetcher {
    public ExtendedJpaDataFetcher(EntityManager entityManager, EntityType<?> entityType) {
        super(entityManager, entityType);
    }

    @Override
    public Object get(DataFetchingEnvironment environment) {
        Field field = (Field)environment.getFields().iterator().next();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        PageInformation pageInformation = this.extractPageInformation(environment, field);
        Optional<Field> totalPagesSelection = this.getSelectionField(field, "totalPages");
        Optional<Field> totalElementsSelection = this.getSelectionField(field, "totalElements");
        Optional<Field> contentSelection = this.getSelectionField(field, "content");
        if (contentSelection.isPresent()) {
            result.put("content", this.getQuery(environment, contentSelection.get()).setMaxResults(pageInformation.size.intValue()).setFirstResult((pageInformation.page - 1) * pageInformation.size).getResultList());
        }
        if (totalElementsSelection.isPresent() || totalPagesSelection.isPresent()) {
            Long totalElements = contentSelection.map(contentField -> (Long)this.getCountQuery(environment, (Field)contentField).getSingleResult()).orElseGet(() -> (Long)this.getCountQuery(environment, new Field()).getSingleResult());
            result.put("totalElements", totalElements);
            result.put("totalPages", Double.valueOf(Math.ceil((double)totalElements.longValue() / (double)pageInformation.size.intValue())).longValue());
        }
        return result;
    }

    private TypedQuery<Long> getCountQuery(DataFetchingEnvironment environment, Field field) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(this.entityType);
        SingularAttribute idAttribute = this.entityType.getId(Object.class);
        query.select((Selection)cb.count((Expression)root.get(idAttribute.getName())));
        List<Predicate> predicates = field.getArguments().stream().map(it -> cb.equal((Expression)root.get(it.getName()), this.convertValue(environment, (Argument)it, it.getValue()))).collect(Collectors.toList());
        query.where(predicates.toArray(new Predicate[predicates.size()]));
        return this.entityManager.createQuery(query);
    }

    private Optional<Field> getSelectionField(Field field, String fieldName) {
        return field.getSelectionSet().getSelections().stream().filter(it -> it instanceof Field).map(it -> (Field)it).filter(it -> fieldName.equals(it.getName())).findFirst();
    }

    private PageInformation extractPageInformation(DataFetchingEnvironment environment, Field field) {
        Optional<Argument> paginationRequest = field.getArguments().stream().filter(it -> "paginationRequest".equals(it.getName())).findFirst();
        if (paginationRequest.isPresent()) {
            field.getArguments().remove(paginationRequest.get());
            ObjectValue paginationValues = (ObjectValue)paginationRequest.get().getValue();
            IntValue page = (IntValue)paginationValues.getObjectFields().stream().filter(it -> "page".equals(it.getName())).findFirst().get().getValue();
            IntValue size = (IntValue)paginationValues.getObjectFields().stream().filter(it -> "size".equals(it.getName())).findFirst().get().getValue();
            return new PageInformation(page.getValue().intValue(), size.getValue().intValue());
        }
        return new PageInformation(1, Integer.MAX_VALUE);
    }

    private static final class PageInformation {
        public Integer page;
        public Integer size;

        public PageInformation(Integer page, Integer size) {
            this.page = page;
            this.size = size;
        }
    }
}

