/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.execution.TypeFromAST;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import graphql.validation.rules.VariablesTypesMatcher;
import java.util.LinkedHashMap;
import java.util.Map;

public class VariableTypesMatchRule
extends AbstractRule {
    final VariablesTypesMatcher variablesTypesMatcher;
    private Map<String, VariableDefinition> variableDefinitionMap;

    public VariableTypesMatchRule(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        this(validationContext, validationErrorCollector, new VariablesTypesMatcher());
    }

    VariableTypesMatchRule(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector, VariablesTypesMatcher variablesTypesMatcher) {
        super(validationContext, validationErrorCollector);
        this.setVisitFragmentSpreads(true);
        this.variablesTypesMatcher = variablesTypesMatcher;
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        this.variableDefinitionMap = new LinkedHashMap<String, VariableDefinition>();
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        this.variableDefinitionMap.put(variableDefinition.getName(), variableDefinition);
    }

    @Override
    public void checkVariable(VariableReference variableReference) {
        VariableDefinition variableDefinition = this.variableDefinitionMap.get(variableReference.getName());
        if (variableDefinition == null) {
            return;
        }
        GraphQLType variableType = TypeFromAST.getTypeFromAST(this.getValidationContext().getSchema(), variableDefinition.getType());
        if (variableType == null) {
            return;
        }
        GraphQLInputType inputType = this.getValidationContext().getInputType();
        if (!this.variablesTypesMatcher.doesVariableTypesMatch(variableType, variableDefinition.getDefaultValue(), inputType)) {
            String message = "Variable type doesn't match";
            this.addError(new ValidationError(ValidationErrorType.VariableTypeMismatch, variableReference.getSourceLocation(), message));
        }
    }
}

