/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.language.SourceLocation;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.List;

public class ValidationError
implements GraphQLError {
    private final String message;
    private final List<SourceLocation> locations = new ArrayList<SourceLocation>();
    private final String description;
    private final ValidationErrorType validationErrorType;

    public ValidationError(ValidationErrorType validationErrorType) {
        this(validationErrorType, (SourceLocation)null, null);
    }

    public ValidationError(ValidationErrorType validationErrorType, SourceLocation sourceLocation, String description) {
        this.validationErrorType = validationErrorType;
        if (sourceLocation != null) {
            this.locations.add(sourceLocation);
        }
        this.description = description;
        this.message = this.mkMessage(validationErrorType, description);
    }

    public ValidationError(ValidationErrorType validationErrorType, List<SourceLocation> sourceLocations, String description) {
        this.validationErrorType = validationErrorType;
        if (sourceLocations != null) {
            this.locations.addAll(sourceLocations);
        }
        this.description = description;
        this.message = this.mkMessage(validationErrorType, description);
    }

    private String mkMessage(ValidationErrorType validationErrorType, String description) {
        return String.format("Validation error of type %s: %s", new Object[]{validationErrorType, description});
    }

    public ValidationErrorType getValidationErrorType() {
        return this.validationErrorType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.ValidationError;
    }

    public String toString() {
        return "ValidationError{validationErrorType=" + (Object)((Object)this.validationErrorType) + ", message=" + this.message + ", locations=" + this.locations + ", description='" + this.description + '\'' + '}';
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

