/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.language.Node;
import graphql.validation.DocumentVisitor;
import java.util.ArrayList;
import java.util.List;

@Internal
public class LanguageTraversal {
    private final List<Node> path;

    public LanguageTraversal() {
        this.path = new ArrayList<Node>();
    }

    public LanguageTraversal(List<Node> basePath) {
        this.path = basePath != null ? basePath : new ArrayList<Node>();
    }

    public void traverse(Node root, DocumentVisitor documentVisitor) {
        this.traverseImpl(root, documentVisitor, this.path);
    }

    private void traverseImpl(Node root, DocumentVisitor documentVisitor, List<Node> path) {
        documentVisitor.enter(root, path);
        path.add(root);
        for (Node child : root.getChildren()) {
            this.traverseImpl(child, documentVisitor, path);
        }
        path.remove(path.size() - 1);
        documentVisitor.leave(root, path);
    }
}

