/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.visibility;

import graphql.PublicApi;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@PublicApi
public class BlockedFields
implements GraphqlFieldVisibility {
    private final List<Pattern> patterns;

    public BlockedFields(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
        return fieldsContainer.getFieldDefinitions().stream().filter(fd -> !this.block(this.mkFQN(fieldsContainer, (GraphQLFieldDefinition)fd))).collect(Collectors.toList());
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
        GraphQLFieldDefinition fieldDefinition = fieldsContainer.getFieldDefinition(fieldName);
        if (fieldDefinition != null && this.block(this.mkFQN(fieldsContainer, fieldDefinition))) {
            fieldDefinition = null;
        }
        return fieldDefinition;
    }

    private boolean block(String fqn) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(fqn).matches()) continue;
            return true;
        }
        return false;
    }

    private String mkFQN(GraphQLFieldsContainer fieldsContainer, GraphQLFieldDefinition fieldDefinition) {
        return fieldsContainer.getName() + "." + fieldDefinition.getName();
    }

    public static Builder newBlock() {
        return new Builder();
    }

    public static class Builder {
        private final List<Pattern> patterns = new ArrayList<Pattern>();

        public Builder addPattern(String regexPattern) {
            return this.addCompiledPattern(Pattern.compile(regexPattern));
        }

        public Builder addPatterns(Collection<String> regexPatterns) {
            regexPatterns.forEach(this::addPattern);
            return this;
        }

        public Builder addCompiledPattern(Pattern regex) {
            this.patterns.add(regex);
            return this;
        }

        public Builder addCompiledPatterns(Collection<Pattern> regexes) {
            regexes.forEach(this::addCompiledPattern);
            return this;
        }

        public BlockedFields build() {
            return new BlockedFields(this.patterns);
        }
    }
}

