/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.schema.DataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public class TypeRuntimeWiring {
    private final String typeName;
    private final DataFetcher defaultDataFetcher;
    private final Map<String, DataFetcher> fieldDataFetchers;
    private final TypeResolver typeResolver;
    private final EnumValuesProvider enumValuesProvider;

    private TypeRuntimeWiring(String typeName, DataFetcher defaultDataFetcher, Map<String, DataFetcher> fieldDataFetchers, TypeResolver typeResolver, EnumValuesProvider enumValuesProvider) {
        this.typeName = typeName;
        this.defaultDataFetcher = defaultDataFetcher;
        this.fieldDataFetchers = fieldDataFetchers;
        this.typeResolver = typeResolver;
        this.enumValuesProvider = enumValuesProvider;
    }

    public static Builder newTypeWiring(String typeName) {
        Assert.assertNotNull(typeName, "You must provide a type name");
        return new Builder().typeName(typeName);
    }

    public static TypeRuntimeWiring newTypeWiring(String typeName, UnaryOperator<Builder> builderFunction) {
        return ((Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName))).build();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Map<String, DataFetcher> getFieldDataFetchers() {
        return this.fieldDataFetchers;
    }

    public DataFetcher getDefaultDataFetcher() {
        return this.defaultDataFetcher;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public EnumValuesProvider getEnumValuesProvider() {
        return this.enumValuesProvider;
    }

    public static class Builder {
        private final Map<String, DataFetcher> fieldDataFetchers = new LinkedHashMap<String, DataFetcher>();
        private String typeName;
        private DataFetcher defaultDataFetcher;
        private TypeResolver typeResolver;
        private EnumValuesProvider enumValuesProvider;

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder dataFetcher(String fieldName, DataFetcher dataFetcher) {
            Assert.assertNotNull(dataFetcher, "you must provide a data fetcher");
            Assert.assertNotNull(fieldName, "you must tell us what field");
            this.fieldDataFetchers.put(fieldName, dataFetcher);
            return this;
        }

        public Builder dataFetchers(Map<String, DataFetcher> dataFetchersMap) {
            Assert.assertNotNull(dataFetchersMap, "you must provide a data fetchers map");
            this.fieldDataFetchers.putAll(dataFetchersMap);
            return this;
        }

        public Builder defaultDataFetcher(DataFetcher dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            this.defaultDataFetcher = dataFetcher;
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            Assert.assertNotNull(typeResolver, "you must provide a type resolver");
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder enumValues(EnumValuesProvider enumValuesProvider) {
            Assert.assertNotNull(enumValuesProvider, "you must provide a type resolver");
            this.enumValuesProvider = enumValuesProvider;
            return this;
        }

        public TypeRuntimeWiring build() {
            Assert.assertNotNull(this.typeName, "you must provide a type name");
            return new TypeRuntimeWiring(this.typeName, this.defaultDataFetcher, this.fieldDataFetchers, this.typeResolver, this.enumValuesProvider);
        }
    }
}

