/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.language.Document;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaPrinter {
    private final Map<Class, TypePrinter<?>> printers = new LinkedHashMap();
    private final Options options;

    public SchemaPrinter() {
        this(Options.defaultOptions());
    }

    public SchemaPrinter(Options options) {
        this.options = options;
        this.printers.put(GraphQLSchema.class, this.schemaPrinter());
        this.printers.put(GraphQLObjectType.class, this.objectPrinter());
        this.printers.put(GraphQLEnumType.class, this.enumPrinter());
        this.printers.put(GraphQLScalarType.class, this.scalarPrinter());
        this.printers.put(GraphQLInterfaceType.class, this.interfacePrinter());
        this.printers.put(GraphQLUnionType.class, this.unionPrinter());
        this.printers.put(GraphQLInputObjectType.class, this.inputObjectPrinter());
    }

    public String print(Document schemaIDL) {
        TypeDefinitionRegistry registry = new SchemaParser().buildRegistry(schemaIDL);
        return this.print(UnExecutableSchemaGenerator.makeUnExecutableSchema(registry));
    }

    public String print(GraphQLSchema schema) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        GraphqlFieldVisibility visibility = schema.getFieldVisibility();
        this.printer(schema.getClass()).print(out, schema, visibility);
        List<GraphQLType> typesAsList = schema.getAllTypesAsList().stream().sorted(Comparator.comparing(GraphQLType::getName)).collect(Collectors.toList());
        this.printType(out, typesAsList, GraphQLInterfaceType.class, visibility);
        this.printType(out, typesAsList, GraphQLUnionType.class, visibility);
        this.printType(out, typesAsList, GraphQLObjectType.class, visibility);
        this.printType(out, typesAsList, GraphQLEnumType.class, visibility);
        this.printType(out, typesAsList, GraphQLScalarType.class, visibility);
        this.printType(out, typesAsList, GraphQLInputObjectType.class, visibility);
        String result = sw.toString();
        if (result.endsWith("\n\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private boolean isIntrospectionType(GraphQLType type) {
        return !this.options.isIncludeIntrospectionTypes() && type.getName().startsWith("__");
    }

    private TypePrinter<GraphQLScalarType> scalarPrinter() {
        return (out, type, visibility) -> {
            boolean printScalar;
            if (!this.options.isIncludeScalars()) {
                return;
            }
            if (ScalarInfo.isStandardScalar(type)) {
                printScalar = false;
                if (this.options.isIncludeExtendedScalars() && !ScalarInfo.isGraphqlSpecifiedScalar(type)) {
                    printScalar = true;
                }
            } else {
                printScalar = true;
            }
            if (printScalar) {
                this.printComments(out, type, "");
                out.format("scalar %s\n\n", type.getName());
            }
        };
    }

    private TypePrinter<GraphQLEnumType> enumPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            out.format("enum %s {\n", type.getName());
            List values = type.getValues().stream().sorted(Comparator.comparing(GraphQLEnumValueDefinition::getName)).collect(Collectors.toList());
            for (GraphQLEnumValueDefinition enumValueDefinition : values) {
                this.printComments(out, enumValueDefinition, "  ");
                out.format("  %s\n", enumValueDefinition.getName());
            }
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInterfaceType> interfacePrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            out.format("interface %s {\n", type.getName());
            visibility.getFieldDefinitions((GraphQLFieldsContainer)type).stream().sorted(Comparator.comparing(GraphQLFieldDefinition::getName)).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s%s: %s\n", fd.getName(), this.argsString(fd.getArguments()), this.typeString(fd.getType()));
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLUnionType> unionPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            out.format("union %s = ", type.getName());
            List types = type.getTypes().stream().sorted(Comparator.comparing(GraphQLType::getName)).collect(Collectors.toList());
            for (int i = 0; i < types.size(); ++i) {
                GraphQLOutputType objectType = (GraphQLOutputType)types.get(i);
                if (i > 0) {
                    out.format(" | ", new Object[0]);
                }
                out.format("%s", objectType.getName());
            }
            out.format("\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLObjectType> objectPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            if (type.getInterfaces().isEmpty()) {
                out.format("type %s {\n", type.getName());
            } else {
                Stream<String> interfaceNames = type.getInterfaces().stream().map(GraphQLType::getName).sorted(Comparator.naturalOrder());
                out.format("type %s implements %s {\n", type.getName(), interfaceNames.collect(Collectors.joining(", ")));
            }
            visibility.getFieldDefinitions((GraphQLFieldsContainer)type).stream().sorted(Comparator.comparing(GraphQLFieldDefinition::getName)).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s%s: %s\n", fd.getName(), this.argsString(fd.getArguments()), this.typeString(fd.getType()));
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInputObjectType> inputObjectPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            out.format("input %s {\n", type.getName());
            type.getFieldDefinitions().stream().sorted(Comparator.comparing(GraphQLInputObjectField::getName)).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s: %s\n", fd.getName(), this.typeString(fd.getType()));
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLSchema> schemaPrinter() {
        return (out, type, visibility) -> {
            GraphQLObjectType queryType = type.getQueryType();
            GraphQLObjectType mutationType = type.getMutationType();
            GraphQLObjectType subscriptionType = type.getSubscriptionType();
            boolean needsSchemaPrinted = false;
            if (queryType != null && !queryType.getName().equals("Query")) {
                needsSchemaPrinted = true;
            }
            if (mutationType != null && !mutationType.getName().equals("Mutation")) {
                needsSchemaPrinted = true;
            }
            if (subscriptionType != null && !subscriptionType.getName().equals("Subscription")) {
                needsSchemaPrinted = true;
            }
            if (needsSchemaPrinted) {
                out.format("schema {\n", new Object[0]);
                if (queryType != null) {
                    out.format("  query: %s\n", queryType.getName());
                }
                if (mutationType != null) {
                    out.format("  mutation: %s\n", mutationType.getName());
                }
                if (subscriptionType != null) {
                    out.format("  subscription: %s\n", subscriptionType.getName());
                }
                out.format("}\n\n", new Object[0]);
            }
        };
    }

    String typeString(GraphQLType rawType) {
        StringBuilder sb = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        GraphQLType type = rawType;
        while (true) {
            if (type instanceof GraphQLNonNull) {
                type = ((GraphQLNonNull)type).getWrappedType();
                stack.push("!");
                continue;
            }
            if (!(type instanceof GraphQLList)) break;
            type = ((GraphQLList)type).getWrappedType();
            sb.append("[");
            stack.push("]");
        }
        sb.append(type.getName());
        while (!stack.isEmpty()) {
            sb.append((String)stack.pop());
        }
        return sb.toString();
    }

    String argsString(List<GraphQLArgument> arguments) {
        boolean hasDescriptions = arguments.stream().filter(arg -> !SchemaPrinter.isNullOrEmpty(arg.getDescription())).count() > 0L;
        String prefix = hasDescriptions ? "  " : "";
        int count = 0;
        StringBuilder sb = new StringBuilder();
        arguments = arguments.stream().sorted(Comparator.comparing(GraphQLArgument::getName)).collect(Collectors.toList());
        for (GraphQLArgument argument : arguments) {
            String description;
            if (count == 0) {
                sb.append("(");
            } else {
                sb.append(", ");
            }
            if (hasDescriptions) {
                sb.append("\n");
            }
            if (!SchemaPrinter.isNullOrEmpty(description = argument.getDescription())) {
                Stream<String> stream = Arrays.stream(description.split("\n"));
                stream.map(s -> "  #" + s + "\n").forEach(sb::append);
            }
            sb.append(prefix).append(argument.getName()).append(": ").append(this.typeString(argument.getType()));
            Object defaultValue = argument.getDefaultValue();
            if (defaultValue != null) {
                sb.append(" = ");
                if (defaultValue instanceof Number) {
                    sb.append(defaultValue);
                } else {
                    sb.append('\"').append(defaultValue).append('\"');
                }
            }
            ++count;
        }
        if (count > 0) {
            if (hasDescriptions) {
                sb.append("\n");
            }
            sb.append(prefix).append(")");
        }
        return sb.toString();
    }

    private <T> TypePrinter<T> printer(Class<?> clazz) {
        TypePrinter typePrinter = this.printers.computeIfAbsent(clazz, k -> {
            Class superClazz = clazz.getSuperclass();
            TypePrinter<Object> result = superClazz != Object.class ? this.printer(superClazz) : (out, type, visibility) -> out.println("Type not implemented : " + type);
            return result;
        });
        return typePrinter;
    }

    public String print(GraphQLType type) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printType(out, type, DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY);
        return sw.toString();
    }

    private void printType(PrintWriter out, List<GraphQLType> typesAsList, Class typeClazz, GraphqlFieldVisibility visibility) {
        typesAsList.stream().filter(type -> typeClazz.isAssignableFrom(type.getClass())).forEach(type -> this.printType(out, (GraphQLType)type, visibility));
    }

    private void printType(PrintWriter out, GraphQLType type, GraphqlFieldVisibility visibility) {
        TypePrinter<GraphQLType> printer = this.printer(type.getClass());
        printer.print(out, type, visibility);
    }

    private void printComments(PrintWriter out, Object graphQLType, String prefix) {
        String description = this.getDescription(graphQLType);
        if (SchemaPrinter.isNullOrEmpty(description)) {
            return;
        }
        Stream<String> stream = Arrays.stream(description.split("\n"));
        stream.map(s -> prefix + "#" + s + "\n").forEach(out::write);
    }

    private String getDescription(Object descriptionHolder) {
        if (descriptionHolder instanceof GraphQLObjectType) {
            return ((GraphQLObjectType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLFieldDefinition) {
            return ((GraphQLFieldDefinition)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLEnumValueDefinition) {
            return ((GraphQLEnumValueDefinition)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLInputObjectType) {
            return ((GraphQLInputObjectType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLInputObjectField) {
            return ((GraphQLInputObjectField)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLInterfaceType) {
            return ((GraphQLInterfaceType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)descriptionHolder).getDescription();
        }
        if (descriptionHolder instanceof GraphQLArgument) {
            return ((GraphQLArgument)descriptionHolder).getDescription();
        }
        return (String)Assert.assertShouldNeverHappen();
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static interface TypePrinter<T> {
        public void print(PrintWriter var1, T var2, GraphqlFieldVisibility var3);
    }

    public static class Options {
        private final boolean includeIntrospectionTypes;
        private final boolean includeScalars;
        private final boolean includeExtendedScalars;

        private Options(boolean includeIntrospectionTypes, boolean includeScalars, boolean includeExtendedScalars) {
            this.includeIntrospectionTypes = includeIntrospectionTypes;
            this.includeScalars = includeScalars;
            this.includeExtendedScalars = includeExtendedScalars;
        }

        public boolean isIncludeIntrospectionTypes() {
            return this.includeIntrospectionTypes;
        }

        public boolean isIncludeScalars() {
            return this.includeScalars;
        }

        public boolean isIncludeExtendedScalars() {
            return this.includeExtendedScalars;
        }

        public static Options defaultOptions() {
            return new Options(false, false, false);
        }

        public Options includeIntrospectionTypes(boolean flag) {
            return new Options(flag, this.includeScalars, this.includeExtendedScalars);
        }

        public Options includeScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, flag, this.includeExtendedScalars);
        }

        public Options includeExtendedScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, flag);
        }
    }
}

