/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeExtensionDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class SchemaGenerator {
    private final SchemaTypeChecker typeChecker = new SchemaTypeChecker();

    public GraphQLSchema makeExecutableSchema(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        List<GraphQLError> errors = this.typeChecker.checkTypeRegistry(typeRegistry, wiring);
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        BuildContext buildCtx = new BuildContext(typeRegistry, wiring);
        return this.makeExecutableSchemaImpl(buildCtx);
    }

    private GraphQLSchema makeExecutableSchemaImpl(BuildContext buildCtx) {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        if (!typeRegistry.schemaDefinition().isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef;
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            GraphQLObjectType query = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(queryTypeDef.getName()));
            schemaBuilder.query(query);
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(mutationTypeDef.get().getName()));
                schemaBuilder.mutation(mutation);
            }
            if ((subscriptionTypeDef = typeRegistry.getType("Subscription")).isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(subscriptionTypeDef.get().getName()));
                schemaBuilder.subscription(subscription);
            }
        } else {
            SchemaDefinition schemaDefinition = typeRegistry.schemaDefinition().get();
            List<OperationTypeDefinition> operationTypes = schemaDefinition.getOperationTypeDefinitions();
            OperationTypeDefinition queryOp = operationTypes.stream().filter(op -> "query".equals(op.getName())).findFirst().get();
            Optional<OperationTypeDefinition> mutationOp = operationTypes.stream().filter(op -> "mutation".equals(op.getName())).findFirst();
            Optional<OperationTypeDefinition> subscriptionOp = operationTypes.stream().filter(op -> "subscription".equals(op.getName())).findFirst();
            GraphQLObjectType query = this.buildOperation(buildCtx, queryOp);
            schemaBuilder.query(query);
            if (mutationOp.isPresent()) {
                GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOp.get());
                schemaBuilder.mutation(mutation);
            }
            if (subscriptionOp.isPresent()) {
                GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOp.get());
                schemaBuilder.subscription(subscription);
            }
        }
        Set<GraphQLType> additionalTypes = this.buildAdditionalTypes(buildCtx);
        schemaBuilder.fieldVisibility(buildCtx.getWiring().getFieldVisibility());
        return schemaBuilder.build(additionalTypes);
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        Type type = operation.getType();
        return (GraphQLObjectType)this.buildOutputType(buildCtx, type);
    }

    private Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        typeRegistry.types().values().forEach(typeDefinition -> {
            TypeName typeName = new TypeName(typeDefinition.getName());
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition)typeDefinition) == null) {
                    additionalTypes.add(this.buildInputType(buildCtx, typeName));
                }
            } else if (buildCtx.hasOutputType((TypeDefinition)typeDefinition) == null) {
                additionalTypes.add((GraphQLType)this.buildOutputType(buildCtx, typeName));
            }
        });
        return additionalTypes;
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(new GraphQLTypeReference(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(typeDefinition);
        }
        buildCtx.put(outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    private GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(new GraphQLTypeReference(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(typeDefinition);
        }
        buildCtx.put(inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    private GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition));
        List<TypeExtensionDefinition> typeExtensions = this.getTypeExtensionsOf(typeDefinition, buildCtx);
        this.buildObjectTypeFields(buildCtx, typeDefinition, builder, typeExtensions);
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, typeExtensions);
        return builder.build();
    }

    private void buildObjectTypeFields(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<TypeExtensionDefinition> typeExtensions) {
        LinkedHashMap fieldDefinitions = new LinkedHashMap();
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition newFieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            fieldDefinitions.put(newFieldDefinition.getName(), newFieldDefinition);
        });
        typeExtensions.forEach(typeExt -> typeExt.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition newFieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!fieldDefinitions.containsKey(newFieldDefinition.getName())) {
                fieldDefinitions.put(newFieldDefinition.getName(), newFieldDefinition);
            }
        }));
        fieldDefinitions.values().forEach(builder::field);
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<TypeExtensionDefinition> typeExtensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLInterfaceType newInterfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        typeExtensions.forEach(typeExt -> typeExt.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(builder::withInterface);
    }

    private List<TypeExtensionDefinition> getTypeExtensionsOf(ObjectTypeDefinition objectTypeDefinition, BuildContext buildCtx) {
        List<TypeExtensionDefinition> typeExtensionDefinitions = buildCtx.typeRegistry.typeExtensions().get(objectTypeDefinition.getName());
        return typeExtensionDefinitions == null ? Collections.emptyList() : typeExtensionDefinitions;
    }

    private GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition));
        builder.typeResolver(this.getTypeResolverForInterface(buildCtx, typeDefinition));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> builder.field(this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef)));
        return builder.build();
    }

    private GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition));
        builder.typeResolver(this.getTypeResolverForUnion(buildCtx, typeDefinition));
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        return builder.build();
    }

    private GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition));
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            Object value;
            String description = this.buildDescription((Node)evd);
            String deprecation = this.buildDeprecationReason(evd.getDirectives());
            if (enumValuesProvider != null) {
                value = enumValuesProvider.getValue(evd.getName());
                Assert.assertNotNull(value, String.format("EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName()));
            } else {
                value = evd.getName();
            }
            builder.value(evd.getName(), value, description, deprecation);
        });
        return builder.build();
    }

    private GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        return buildCtx.getWiring().getScalars().get(typeDefinition.getName());
    }

    private GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(fieldDef);
        builder.name(fieldDef.getName());
        builder.description(this.buildDescription(fieldDef));
        builder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        builder.dataFetcherFactory(this.buildDataFetcherFactory(buildCtx, parentType, fieldDef));
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object outputType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)outputType);
        return builder.build();
    }

    private DataFetcherFactory buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        DataFetcherFactory dataFetcherFactory;
        FieldWiringEnvironment wiringEnvironment;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef))) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, "The WiringFactory indicated it provides a data fetcher factory but then returned null");
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, "The WiringFactory indicated it provides a data fetcher but then returned null");
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null) {
                    dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment);
                    Assert.assertNotNull(dataFetcher, "The WiringFactory indicated MUST provide a default data fetcher as part of its contract");
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    private GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition));
        typeDefinition.getInputValueDefinitions().forEach(fieldDef -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)fieldDef)));
        return builder.build();
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(fieldDef);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(this.buildDescription(fieldDef));
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        fieldBuilder.defaultValue(this.buildValue(fieldDef.getDefaultValue(), inputType));
        return fieldBuilder.build();
    }

    private GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(valueDefinition);
        builder.name(valueDefinition.getName());
        builder.description(this.buildDescription(valueDefinition));
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        builder.defaultValue(this.buildValue(valueDefinition.getDefaultValue(), inputType));
        return builder.build();
    }

    private Object buildValue(Value value, GraphQLType requiredType) {
        List result = null;
        if (requiredType instanceof GraphQLNonNull) {
            requiredType = ((GraphQLNonNull)requiredType).getWrappedType();
        }
        if (requiredType instanceof GraphQLScalarType) {
            result = (List)((GraphQLScalarType)requiredType).getCoercing().parseLiteral(value);
        } else if (value instanceof EnumValue && requiredType instanceof GraphQLEnumType) {
            result = ((EnumValue)value).getName();
        } else if (value instanceof ArrayValue && requiredType instanceof GraphQLList) {
            ArrayValue arrayValue = (ArrayValue)value;
            GraphQLType wrappedType = ((GraphQLList)requiredType).getWrappedType();
            result = arrayValue.getValues().stream().map(item -> this.buildValue((Value)item, wrappedType)).collect(Collectors.toList());
        } else if (value instanceof ObjectValue && requiredType instanceof GraphQLInputObjectType) {
            result = this.buildObjectValue((ObjectValue)value, (GraphQLInputObjectType)requiredType);
        } else if (value != null && !(value instanceof NullValue)) {
            Assert.assertShouldNeverHappen("cannot build value of " + requiredType.getName() + " from " + String.valueOf(value));
        }
        return result;
    }

    private Object buildObjectValue(ObjectValue defaultValue, GraphQLInputObjectType objectType) {
        LinkedHashMap map = new LinkedHashMap();
        defaultValue.getObjectFields().forEach(of -> map.put(of.getName(), this.buildValue(of.getValue(), objectType.getField(of.getName()).getType())));
        return map;
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it union provides a type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it provides a interface type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private String buildDescription(Node node) {
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = directives == null ? Collections.emptyList() : directives).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return "No longer supported";
            }
            return args.get("reason");
        }
        return null;
    }

    class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Stack<String> definitionStack = new Stack();
        private final Map<String, GraphQLOutputType> outputGTypes = new HashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new HashMap<String, GraphQLInputType>();

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition getTypeDefinition(Type type) {
            return this.typeRegistry.getType(type).get();
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.definitionStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.definitionStack.push(typeInfo.getName());
        }

        void pop() {
            this.definitionStack.pop();
        }

        GraphQLOutputType hasOutputType(TypeDefinition typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void put(GraphQLOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void put(GraphQLInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }
    }
}

