/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff.reporting;

import graphql.PublicApi;
import graphql.schema.diff.DiffEvent;
import graphql.schema.diff.DiffLevel;
import graphql.schema.diff.reporting.DifferenceReporter;
import java.util.ArrayList;
import java.util.List;

@PublicApi
public class CapturingReporter
implements DifferenceReporter {
    private final List<DiffEvent> events = new ArrayList<DiffEvent>();
    private final List<DiffEvent> breakages = new ArrayList<DiffEvent>();
    private final List<DiffEvent> dangers = new ArrayList<DiffEvent>();

    @Override
    public void report(DiffEvent differenceEvent) {
        this.events.add(differenceEvent);
        if (differenceEvent.getLevel() == DiffLevel.BREAKING) {
            this.breakages.add(differenceEvent);
        }
        if (differenceEvent.getLevel() == DiffLevel.DANGEROUS) {
            this.dangers.add(differenceEvent);
        }
    }

    @Override
    public void onEnd() {
    }

    public List<DiffEvent> getEvents() {
        return new ArrayList<DiffEvent>(this.events);
    }

    public List<DiffEvent> getBreakages() {
        return new ArrayList<DiffEvent>(this.breakages);
    }

    public List<DiffEvent> getDangers() {
        return new ArrayList<DiffEvent>(this.dangers);
    }

    public int getBreakageCount() {
        return this.breakages.size();
    }

    public int getDangerCount() {
        return this.dangers.size();
    }
}

