/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@PublicApi
public class PropertyDataFetcher<T>
implements DataFetcher<T> {
    private final String propertyName;
    private final Function<Object, Object> function;

    public PropertyDataFetcher(String propertyName) {
        this.propertyName = propertyName;
        this.function = null;
    }

    private <O> PropertyDataFetcher(Function<O, T> function) {
        this.function = Assert.assertNotNull(function);
        this.propertyName = null;
    }

    public static <T> PropertyDataFetcher<T> fetching(String propertyName) {
        return new PropertyDataFetcher<T>(propertyName);
    }

    public static <T, O> PropertyDataFetcher<T> fetching(Function<O, T> function) {
        return new PropertyDataFetcher<T>(function);
    }

    @Override
    public T get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (this.function != null) {
            return (T)this.function.apply(source);
        }
        if (source instanceof Map) {
            return (T)((Map)source).get(this.propertyName);
        }
        return (T)this.getPropertyViaGetter(source, environment.getFieldType());
    }

    private Object getPropertyViaGetter(Object object, GraphQLOutputType outputType) {
        try {
            return this.getPropertyViaGetterMethod(object, outputType, this::findPubliclyAccessibleMethod);
        }
        catch (NoSuchMethodException ignored) {
            try {
                return this.getPropertyViaGetterMethod(object, outputType, this::findViaSetAccessible);
            }
            catch (NoSuchMethodException ignored2) {
                return this.getPropertyViaFieldAccess(object);
            }
        }
    }

    private Object getPropertyViaGetterMethod(Object object, GraphQLOutputType outputType, MethodFinder methodFinder) throws NoSuchMethodException {
        if (this.isBooleanProperty(outputType)) {
            try {
                return this.getPropertyViaGetterUsingPrefix(object, "is", methodFinder);
            }
            catch (NoSuchMethodException e) {
                return this.getPropertyViaGetterUsingPrefix(object, "get", methodFinder);
            }
        }
        return this.getPropertyViaGetterUsingPrefix(object, "get", methodFinder);
    }

    private Object getPropertyViaGetterUsingPrefix(Object object, String prefix, MethodFinder methodFinder) throws NoSuchMethodException {
        String getterName = prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        try {
            Method method = methodFinder.apply(object.getClass(), getterName);
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLOutputType outputType) {
        if (outputType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (outputType instanceof GraphQLNonNull) {
            return ((GraphQLNonNull)outputType).getWrappedType() == Scalars.GraphQLBoolean;
        }
        return false;
    }

    private Method findPubliclyAccessibleMethod(Class root, String methodName) throws NoSuchMethodException {
        for (Class cur = root; cur != null; cur = cur.getSuperclass()) {
            Method m;
            if (!Modifier.isPublic(cur.getModifiers()) || !Modifier.isPublic((m = cur.getMethod(methodName, new Class[0])).getModifiers())) continue;
            return m;
        }
        return root.getMethod(methodName, new Class[0]);
    }

    private Method findViaSetAccessible(Class aClass, String methodName) throws NoSuchMethodException {
        Method[] declaredMethods = aClass.getDeclaredMethods();
        Optional<Method> m = Arrays.stream(declaredMethods).filter(method -> methodName.equals(method.getName())).findFirst();
        if (m.isPresent()) {
            try {
                m.get().setAccessible(true);
                return m.get();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    private Object getPropertyViaFieldAccess(Object object) {
        Class<?> aClass = object.getClass();
        try {
            Field field = aClass.getField(this.propertyName);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = aClass.getDeclaredField(this.propertyName);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (NoSuchFieldException | SecurityException ignored2) {
                return null;
            }
            catch (IllegalAccessException e1) {
                throw new GraphQLException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    @FunctionalInterface
    private static interface MethodFinder {
        public Method apply(Class var1, String var2) throws NoSuchMethodException;
    }
}

