/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.UnionTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class GraphQLUnionType
implements GraphQLType,
GraphQLOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType {
    private final String name;
    private final String description;
    private List<GraphQLOutputType> types = new ArrayList<GraphQLOutputType>();
    private final TypeResolver typeResolver;
    private final UnionTypeDefinition definition;

    @Internal
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver) {
        this(name, description, types, typeResolver, null);
    }

    @Internal
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver, UnionTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(types, "types can't be null");
        Assert.assertNotEmpty(types, "A Union type must define one or more member types.");
        Assert.assertNotNull(typeResolver, "typeResolver can't be null");
        this.name = name;
        this.description = description;
        this.types = types;
        this.typeResolver = typeResolver;
        this.definition = definition;
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.types = this.types.stream().map(type -> (GraphQLOutputType)new SchemaUtil().resolveTypeReference((GraphQLType)type, typeMap)).collect(Collectors.toList());
    }

    public List<GraphQLOutputType> getTypes() {
        return new ArrayList<GraphQLOutputType>(this.types);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UnionTypeDefinition getDefinition() {
        return this.definition;
    }

    public static Builder newUnionType() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private final List<GraphQLOutputType> types = new ArrayList<GraphQLOutputType>();
        private TypeResolver typeResolver;
        private UnionTypeDefinition definition;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(UnionTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder possibleType(GraphQLObjectType type) {
            Assert.assertNotNull(type, "possible type can't be null");
            this.types.add(type);
            return this;
        }

        public Builder possibleType(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, "reference can't be null");
            this.types.add(reference);
            return this;
        }

        public Builder possibleTypes(GraphQLObjectType ... type) {
            for (GraphQLObjectType graphQLType : type) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public Builder possibleTypes(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.possibleType(reference);
            }
            return this;
        }

        public GraphQLUnionType build() {
            return new GraphQLUnionType(this.name, this.description, this.types, this.typeResolver, this.definition);
        }
    }
}

