/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Directives;
import graphql.PublicApi;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.SchemaUtil;
import graphql.schema.validation.InvalidSchemaException;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidator;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@PublicApi
public class GraphQLSchema {
    private final GraphQLObjectType queryType;
    private final GraphQLObjectType mutationType;
    private final GraphQLObjectType subscriptionType;
    private final Map<String, GraphQLType> typeMap;
    private final Set<GraphQLType> additionalTypes;
    private final Set<GraphQLDirective> directives;
    private final GraphqlFieldVisibility fieldVisibility;

    public GraphQLSchema(GraphQLObjectType queryType) {
        this(queryType, null, Collections.emptySet());
    }

    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, Set<GraphQLType> additionalTypes) {
        this(queryType, mutationType, null, additionalTypes);
    }

    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, GraphQLObjectType subscriptionType, Set<GraphQLType> dictionary) {
        this(queryType, mutationType, subscriptionType, dictionary, Collections.emptySet(), DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY);
    }

    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, GraphQLObjectType subscriptionType, Set<GraphQLType> dictionary, Set<GraphQLDirective> directives, GraphqlFieldVisibility fieldVisibility) {
        Assert.assertNotNull(dictionary, "dictionary can't be null");
        Assert.assertNotNull(queryType, "queryType can't be null");
        Assert.assertNotNull(directives, "directives can't be null");
        Assert.assertNotNull(fieldVisibility, "fieldVisibility can't be null");
        this.queryType = queryType;
        this.mutationType = mutationType;
        this.subscriptionType = subscriptionType;
        this.fieldVisibility = fieldVisibility;
        this.additionalTypes = dictionary;
        this.directives = new LinkedHashSet<GraphQLDirective>(Arrays.asList(Directives.IncludeDirective, Directives.SkipDirective));
        this.directives.addAll(directives);
        this.typeMap = new SchemaUtil().allTypes(this, dictionary);
    }

    public Set<GraphQLType> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public GraphQLType getType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public GraphQLObjectType getObjectType(String typeName) {
        GraphQLType graphQLType = this.typeMap.get(typeName);
        if (graphQLType != null) {
            Assert.assertTrue(graphQLType instanceof GraphQLObjectType, String.format("You have asked for named object type '%s' but its not an object type but rather a '%s'", typeName, graphQLType.getClass().getName()));
        }
        return (GraphQLObjectType)graphQLType;
    }

    public List<GraphQLType> getAllTypesAsList() {
        return new ArrayList<GraphQLType>(this.typeMap.values());
    }

    public GraphQLObjectType getQueryType() {
        return this.queryType;
    }

    public GraphQLObjectType getMutationType() {
        return this.mutationType;
    }

    public GraphQLObjectType getSubscriptionType() {
        return this.subscriptionType;
    }

    public GraphqlFieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public GraphQLDirective getDirective(String name) {
        for (GraphQLDirective directive : this.getDirectives()) {
            if (!directive.getName().equals(name)) continue;
            return directive;
        }
        return null;
    }

    public boolean isSupportingMutations() {
        return this.mutationType != null;
    }

    public boolean isSupportingSubscriptions() {
        return this.subscriptionType != null;
    }

    public GraphQLSchema transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLSchema.newSchema(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newSchema() {
        return new Builder();
    }

    public static Builder newSchema(GraphQLSchema existingSchema) {
        return new Builder().query(existingSchema.getQueryType()).mutation(existingSchema.getMutationType()).subscription(existingSchema.getSubscriptionType()).fieldVisibility(existingSchema.getFieldVisibility()).additionalDirectives(existingSchema.directives).additionalTypes(existingSchema.additionalTypes);
    }

    public static class Builder {
        private GraphQLObjectType queryType;
        private GraphQLObjectType mutationType;
        private GraphQLObjectType subscriptionType;
        private GraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        private Set<GraphQLType> additionalTypes = Collections.emptySet();
        private Set<GraphQLDirective> additionalDirectives = Collections.emptySet();

        public Builder query(GraphQLObjectType.Builder builder) {
            return this.query(builder.build());
        }

        public Builder query(GraphQLObjectType queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder mutation(GraphQLObjectType.Builder builder) {
            return this.mutation(builder.build());
        }

        public Builder mutation(GraphQLObjectType mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        public Builder subscription(GraphQLObjectType.Builder builder) {
            return this.subscription(builder.build());
        }

        public Builder subscription(GraphQLObjectType subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.fieldVisibility = fieldVisibility;
            return this;
        }

        public Builder additionalTypes(Set<GraphQLType> additionalTypes) {
            this.additionalTypes = additionalTypes;
            return this;
        }

        public Builder additionalDirectives(Set<GraphQLDirective> additionalDirectives) {
            this.additionalDirectives = additionalDirectives;
            return this;
        }

        public GraphQLSchema build() {
            return this.build(this.additionalTypes, this.additionalDirectives);
        }

        public GraphQLSchema build(Set<GraphQLType> additionalTypes) {
            return this.build(additionalTypes, Collections.emptySet());
        }

        public GraphQLSchema build(Set<GraphQLType> additionalTypes, Set<GraphQLDirective> additionalDirectives) {
            Assert.assertNotNull(additionalTypes, "additionalTypes can't be null");
            Assert.assertNotNull(additionalDirectives, "additionalDirectives can't be null");
            GraphQLSchema graphQLSchema = new GraphQLSchema(this.queryType, this.mutationType, this.subscriptionType, additionalTypes, additionalDirectives, this.fieldVisibility);
            new SchemaUtil().replaceTypeReferences(graphQLSchema);
            Set<SchemaValidationError> errors = new SchemaValidator().validateSchema(graphQLSchema);
            if (errors.size() > 0) {
                throw new InvalidSchemaException(errors);
            }
            return graphQLSchema;
        }
    }
}

