/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;

@PublicApi
public class FieldDataFetcher<T>
implements DataFetcher<T> {
    private final String fieldName;

    public FieldDataFetcher(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public T get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return (T)((Map)source).get(this.fieldName);
        }
        return (T)this.getFieldValue(source);
    }

    private Object getFieldValue(Object object) {
        try {
            return object.getClass().getField(this.fieldName).get(object);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }
}

