/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.language.Field;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final DataFetchingFieldSelectionSet NOOP = Collections::emptyMap;
    private final FieldCollector fieldCollector;
    private final FieldCollectorParameters parameters;
    private final List<Field> fields;

    public static DataFetchingFieldSelectionSet newCollector(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields) {
        GraphQLType unwrappedType = ExecutionTypeInfo.unwrapBaseType(fieldType);
        if (unwrappedType instanceof GraphQLFieldsContainer) {
            return new DataFetchingFieldSelectionSetImpl(executionContext, DataFetchingFieldSelectionSetImpl.asObjectTypeOrNull(unwrappedType), fields);
        }
        return NOOP;
    }

    private static GraphQLObjectType asObjectTypeOrNull(GraphQLType unwrappedType) {
        return unwrappedType instanceof GraphQLObjectType ? (GraphQLObjectType)unwrappedType : null;
    }

    private DataFetchingFieldSelectionSetImpl(ExecutionContext executionContext, GraphQLObjectType objectType, List<Field> fields) {
        this.fields = fields;
        this.fieldCollector = new FieldCollector();
        this.parameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(objectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
    }

    @Override
    public Map<String, List<Field>> get() {
        return this.fieldCollector.collectFields(this.parameters, this.fields);
    }
}

