/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.OperationTypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchemaDefinition
extends AbstractNode
implements Definition {
    private final List<Directive> directives = new ArrayList<Directive>();
    private final List<OperationTypeDefinition> operationTypeDefinitions = new ArrayList<OperationTypeDefinition>();

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<OperationTypeDefinition> getOperationTypeDefinitions() {
        return this.operationTypeDefinitions;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.operationTypeDefinitions);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDefinition that = (SchemaDefinition)o;
        return true;
    }

    public String toString() {
        return "SchemaDefinition{directives=" + this.directives + ", operationTypeDefinitions=" + this.operationTypeDefinitions + "}";
    }
}

