/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.GraphQLException;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class NodeUtil {
    public static Map<String, Directive> directivesByName(List<Directive> directives) {
        return NodeUtil.getByName(directives, Directive::getName);
    }

    public static Map<String, Argument> argumentsByName(List<Argument> arguments) {
        return NodeUtil.getByName(arguments, Argument::getName);
    }

    private static <T> Map<String, T> getByName(List<T> namedObjects, Function<T, String> nameFn) {
        return namedObjects.stream().collect(Collectors.toMap(nameFn, Function.identity(), NodeUtil.mergeFirst()));
    }

    private static <T> BinaryOperator<T> mergeFirst() {
        return (o1, o2) -> o1;
    }

    public static GetOperationResult getOperation(Document document, String operationName) {
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        LinkedHashMap<String, OperationDefinition> operationsByName = new LinkedHashMap<String, OperationDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                operationsByName.put(operationDefinition.getName(), operationDefinition);
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        if (operationName == null && operationsByName.size() > 1) {
            throw new GraphQLException("missing operation name");
        }
        OperationDefinition operation = operationName == null ? (OperationDefinition)operationsByName.values().iterator().next() : (OperationDefinition)operationsByName.get(operationName);
        if (operation == null) {
            throw new GraphQLException("no operation found");
        }
        GetOperationResult result = new GetOperationResult();
        result.fragmentsByName = fragmentsByName;
        result.operationDefinition = operation;
        return result;
    }

    public static class GetOperationResult {
        public OperationDefinition operationDefinition;
        public Map<String, FragmentDefinition> fragmentsByName;
    }
}

