/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InterfaceTypeDefinition
extends AbstractNode
implements TypeDefinition {
    private final String name;
    private final List<FieldDefinition> definitions = new ArrayList<FieldDefinition>();
    private final List<Directive> directives = new ArrayList<Directive>();

    public InterfaceTypeDefinition(String name) {
        this.name = name;
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.definitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.definitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceTypeDefinition that = (InterfaceTypeDefinition)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public String toString() {
        return "InterfaceTypeDefinition{name='" + this.name + '\'' + ", fieldDefinitions=" + this.definitions + ", directives=" + this.directives + '}';
    }
}

