/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InputObjectTypeDefinition
extends AbstractNode
implements TypeDefinition {
    private final String name;
    private final List<Directive> directives = new ArrayList<Directive>();
    private final List<InputValueDefinition> inputValueDefinitions = new ArrayList<InputValueDefinition>();

    public InputObjectTypeDefinition(String name) {
        this.name = name;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.inputValueDefinitions);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputObjectTypeDefinition that = (InputObjectTypeDefinition)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public String toString() {
        return "InputObjectTypeDefinition{name='" + this.name + '\'' + ", directives=" + this.directives + ", inputValueDefinitions=" + this.inputValueDefinitions + '}';
    }
}

