/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InlineFragment
extends AbstractNode
implements Selection {
    private TypeName typeCondition;
    private List<Directive> directives = new ArrayList<Directive>();
    private SelectionSet selectionSet;

    public InlineFragment() {
    }

    public InlineFragment(TypeName typeCondition) {
        this.typeCondition = typeCondition;
    }

    public InlineFragment(TypeName typeCondition, List<Directive> directives, SelectionSet selectionSet) {
        this.typeCondition = typeCondition;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public InlineFragment(TypeName typeCondition, SelectionSet selectionSet) {
        this.typeCondition = typeCondition;
        this.selectionSet = selectionSet;
    }

    public TypeName getTypeCondition() {
        return this.typeCondition;
    }

    public void setTypeCondition(TypeName typeCondition) {
        this.typeCondition = typeCondition;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.typeCondition != null) {
            result.add(this.typeCondition);
        }
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public String toString() {
        return "InlineFragment{typeCondition='" + this.typeCondition + '\'' + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }
}

