/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FieldDefinition
extends AbstractNode {
    private final String name;
    private Type type;
    private final List<InputValueDefinition> inputValueDefinitions = new ArrayList<InputValueDefinition>();
    private final List<Directive> directives = new ArrayList<Directive>();

    public FieldDefinition(String name) {
        this.name = name;
    }

    public FieldDefinition(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        result.addAll(this.inputValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", inputValueDefinitions=" + this.inputValueDefinitions + ", directives=" + this.directives + '}';
    }
}

