/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@PublicApi
public class Field
extends AbstractNode
implements Selection {
    private String name;
    private String alias;
    private List<Argument> arguments = new ArrayList<Argument>();
    private List<Directive> directives = new ArrayList<Directive>();
    private SelectionSet selectionSet;

    public Field() {
    }

    public Field(String name) {
        this.name = name;
    }

    public Field(String name, SelectionSet selectionSet) {
        this.name = name;
        this.selectionSet = selectionSet;
    }

    public Field(String name, List<Argument> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    public Field(String name, List<Argument> arguments, List<Directive> directives) {
        this.name = name;
        this.arguments = arguments;
        this.directives = directives;
    }

    public Field(String name, List<Argument> arguments, SelectionSet selectionSet) {
        this.name = name;
        this.arguments = arguments;
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.arguments);
        result.addAll(this.directives);
        if (this.selectionSet != null) {
            result.add(this.selectionSet);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.name != null ? !this.name.equals(field.name) : field.name != null) {
            return false;
        }
        return !(this.alias == null ? field.alias != null : !this.alias.equals(field.alias));
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", arguments=" + this.arguments + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }
}

