/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnumValueDefinition
extends AbstractNode {
    private final String name;
    private final List<Directive> directives;

    public EnumValueDefinition(String name) {
        this(name, null);
    }

    public EnumValueDefinition(String name, List<Directive> directives) {
        this.name = name;
        this.directives = null == directives ? new ArrayList() : directives;
    }

    public String getName() {
        return this.name;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumValueDefinition that = (EnumValueDefinition)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public String toString() {
        return "EnumValueDefinition{name='" + this.name + '\'' + ", directives=" + this.directives + '}';
    }
}

