/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Node;
import graphql.language.NodeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Directive
extends AbstractNode {
    private final String name;
    private final List<Argument> arguments = new ArrayList<Argument>();

    public Directive(String name) {
        this(name, Collections.emptyList());
    }

    public Directive(String name, List<Argument> arguments) {
        this.name = name;
        this.arguments.addAll(arguments);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Map<String, Argument> getArgumentsByName() {
        return NodeUtil.argumentsByName(this.arguments);
    }

    public Argument getArgument(String argumentName) {
        return this.getArgumentsByName().get(argumentName);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        return new ArrayList<Node>(this.arguments);
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Directive directive = (Directive)o;
        return !(this.name == null ? directive.name != null : !this.name.equals(directive.name));
    }

    public String toString() {
        return "Directive{name='" + this.name + '\'' + ", arguments=" + this.arguments + '}';
    }
}

