/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.AssertException;
import graphql.GraphQLException;
import graphql.Scalars;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AstValueHelper {
    public static Value astFromValue(Object value, GraphQLType type) {
        if (value == null) {
            return null;
        }
        if (type instanceof GraphQLNonNull) {
            return AstValueHelper.handleNonNull(value, (GraphQLNonNull)type);
        }
        if (type instanceof GraphQLList) {
            return AstValueHelper.handleList(value, (GraphQLList)type);
        }
        if (type instanceof GraphQLInputObjectType) {
            return AstValueHelper.handleInputObject(value, (GraphQLInputObjectType)type);
        }
        if (!(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType)) {
            throw new AssertException("Must provide Input Type, cannot use: " + type.getClass());
        }
        Object serialized = AstValueHelper.serialize(type, value);
        if (AstValueHelper.isNullish(serialized)) {
            return null;
        }
        if (serialized instanceof Boolean) {
            return new BooleanValue((Boolean)serialized);
        }
        String stringValue = serialized.toString();
        if (serialized instanceof Number) {
            return AstValueHelper.handleNumber(stringValue);
        }
        if (serialized instanceof String) {
            if (type instanceof GraphQLEnumType) {
                return new EnumValue(stringValue);
            }
            if (type == Scalars.GraphQLID && stringValue.matches("^[0-9]+$")) {
                return new IntValue(new BigInteger(stringValue));
            }
            return new StringValue(AstValueHelper.jsonStringify(stringValue));
        }
        throw new AssertException("'Cannot convert value to AST: " + serialized);
    }

    private static Value handleInputObject(Object _value, GraphQLInputObjectType type) {
        Map mapValue = AstValueHelper.objToMap(_value);
        List<GraphQLInputObjectField> fields = type.getFields();
        ArrayList<ObjectField> fieldNodes = new ArrayList<ObjectField>();
        fields.forEach(field -> {
            GraphQLInputType fieldType = field.getType();
            Value nodeValue = AstValueHelper.astFromValue(mapValue.get(field.getName()), fieldType);
            if (nodeValue != null) {
                fieldNodes.add(new ObjectField(field.getName(), nodeValue));
            }
        });
        return new ObjectValue(fieldNodes);
    }

    private static Value handleNumber(String stringValue) {
        if (stringValue.matches("^[0-9]+$")) {
            return new IntValue(new BigInteger(stringValue));
        }
        return new FloatValue(new BigDecimal(stringValue));
    }

    private static Value handleList(Object _value, GraphQLList type) {
        GraphQLType itemType = type.getWrappedType();
        if (_value instanceof Iterable) {
            Iterable iterable = (Iterable)_value;
            ArrayList<Value> valuesNodes = new ArrayList<Value>();
            for (Object item : iterable) {
                Value itemNode = AstValueHelper.astFromValue(item, itemType);
                if (itemNode == null) continue;
                valuesNodes.add(itemNode);
            }
            return new ArrayValue(valuesNodes);
        }
        return AstValueHelper.astFromValue(_value, itemType);
    }

    private static Value handleNonNull(Object _value, GraphQLNonNull type) {
        GraphQLType wrappedType = type.getWrappedType();
        return AstValueHelper.astFromValue(_value, wrappedType);
    }

    private static String jsonStringify(String stringValue) {
        stringValue = stringValue.replace("\"", "\\\"");
        stringValue = stringValue.replace("\\", "\\\\");
        stringValue = stringValue.replace("/", "\\/");
        stringValue = stringValue.replace("\f", "\\f");
        stringValue = stringValue.replace("\n", "\\n");
        stringValue = stringValue.replace("\r", "\\r");
        stringValue = stringValue.replace("\t", "\\t");
        return stringValue;
    }

    private static Object serialize(GraphQLType type, Object value) {
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().serialize(value);
        }
        return ((GraphQLEnumType)type).getCoercing().serialize(value);
    }

    private static boolean isNullish(Object serialized) {
        if (serialized instanceof Number) {
            return Double.isNaN(((Number)serialized).doubleValue());
        }
        return serialized == null;
    }

    private static Map objToMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            BeanInfo info = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method reader = pd.getReadMethod();
                if (reader == null) continue;
                result.put(pd.getName(), reader.invoke(value, new Object[0]));
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
        return result;
    }
}

