/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.ScalarInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi
public class IntrospectionResultToSchema {
    public Document createSchemaDefinition(ExecutionResult introspectionResult) {
        Map introspectionResultMap = (Map)introspectionResult.getData();
        return this.createSchemaDefinition(introspectionResultMap);
    }

    public Document createSchemaDefinition(Map<String, Object> introspectionResult) {
        Assert.assertTrue(introspectionResult.get("__schema") != null, "__schema expected");
        Map schema = (Map)introspectionResult.get("__schema");
        Map queryType = (Map)schema.get("queryType");
        Assert.assertNotNull(queryType, "queryType expected");
        TypeName query = new TypeName((String)queryType.get("name"));
        boolean nonDefaultQueryName = !"Query".equals(query.getName());
        SchemaDefinition schemaDefinition = new SchemaDefinition();
        schemaDefinition.getOperationTypeDefinitions().add(new OperationTypeDefinition("query", query));
        Map mutationType = (Map)schema.get("mutationType");
        boolean nonDefaultMutationName = false;
        if (mutationType != null) {
            TypeName mutation = new TypeName((String)mutationType.get("name"));
            nonDefaultMutationName = !"Mutation".equals(mutation.getName());
            schemaDefinition.getOperationTypeDefinitions().add(new OperationTypeDefinition("mutation", mutation));
        }
        Map subscriptionType = (Map)schema.get("subscriptionType");
        boolean nonDefaultSubscriptionName = false;
        if (subscriptionType != null) {
            TypeName subscription = new TypeName((String)subscriptionType.get("name"));
            nonDefaultSubscriptionName = !"Subscription".equals(subscription.getName());
            schemaDefinition.getOperationTypeDefinitions().add(new OperationTypeDefinition("subscription", subscription));
        }
        Document document = new Document();
        if (nonDefaultQueryName || nonDefaultMutationName || nonDefaultSubscriptionName) {
            document.getDefinitions().add(schemaDefinition);
        }
        List types = (List)schema.get("types");
        for (Map type : types) {
            TypeDefinition typeDefinition = this.createTypeDefinition(type);
            if (typeDefinition == null) continue;
            document.getDefinitions().add(typeDefinition);
        }
        return document;
    }

    private TypeDefinition createTypeDefinition(Map<String, Object> type) {
        String kind = (String)type.get("kind");
        String name = (String)type.get("name");
        if (name.startsWith("__")) {
            return null;
        }
        switch (kind) {
            case "INTERFACE": {
                return this.createInterface(type);
            }
            case "OBJECT": {
                return this.createObject(type);
            }
            case "UNION": {
                return this.createUnion(type);
            }
            case "ENUM": {
                return this.createEnum(type);
            }
            case "INPUT_OBJECT": {
                return this.createInputObject(type);
            }
            case "SCALAR": {
                return this.createScalar(type);
            }
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen("unexpected kind " + kind);
    }

    private TypeDefinition createScalar(Map<String, Object> input) {
        String name = (String)input.get("name");
        if (ScalarInfo.isStandardScalar(name)) {
            return null;
        }
        return new ScalarTypeDefinition(name);
    }

    UnionTypeDefinition createUnion(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("UNION"), "wrong input");
        UnionTypeDefinition unionTypeDefinition = new UnionTypeDefinition((String)input.get("name"));
        unionTypeDefinition.setComments(this.toComment((String)input.get("description")));
        List possibleTypes = (List)input.get("possibleTypes");
        for (Map possibleType : possibleTypes) {
            TypeName typeName = new TypeName((String)possibleType.get("name"));
            unionTypeDefinition.getMemberTypes().add(typeName);
        }
        return unionTypeDefinition;
    }

    EnumTypeDefinition createEnum(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("ENUM"), "wrong input");
        EnumTypeDefinition enumTypeDefinition = new EnumTypeDefinition((String)input.get("name"));
        enumTypeDefinition.setComments(this.toComment((String)input.get("description")));
        List enumValues = (List)input.get("enumValues");
        for (Map enumValue : enumValues) {
            EnumValueDefinition enumValueDefinition = new EnumValueDefinition((String)enumValue.get("name"));
            enumValueDefinition.setComments(this.toComment((String)enumValue.get("description")));
            this.createDeprecatedDirective(enumValue, enumValueDefinition.getDirectives());
            enumTypeDefinition.getEnumValueDefinitions().add(enumValueDefinition);
        }
        return enumTypeDefinition;
    }

    InterfaceTypeDefinition createInterface(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("INTERFACE"), "wrong input");
        InterfaceTypeDefinition interfaceTypeDefinition = new InterfaceTypeDefinition((String)input.get("name"));
        interfaceTypeDefinition.setComments(this.toComment((String)input.get("description")));
        List fields = (List)input.get("fields");
        interfaceTypeDefinition.getFieldDefinitions().addAll(this.createFields(fields));
        return interfaceTypeDefinition;
    }

    InputObjectTypeDefinition createInputObject(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("INPUT_OBJECT"), "wrong input");
        InputObjectTypeDefinition inputObjectTypeDefinition = new InputObjectTypeDefinition((String)input.get("name"));
        inputObjectTypeDefinition.setComments(this.toComment((String)input.get("description")));
        List fields = (List)input.get("inputFields");
        List<InputValueDefinition> inputValueDefinitions = this.createInputValueDefinitions(fields);
        inputObjectTypeDefinition.getInputValueDefinitions().addAll(inputValueDefinitions);
        return inputObjectTypeDefinition;
    }

    ObjectTypeDefinition createObject(Map<String, Object> input) {
        Assert.assertTrue(input.get("kind").equals("OBJECT"), "wrong input");
        ObjectTypeDefinition objectTypeDefinition = new ObjectTypeDefinition((String)input.get("name"));
        objectTypeDefinition.setComments(this.toComment((String)input.get("description")));
        List fields = (List)input.get("fields");
        objectTypeDefinition.getFieldDefinitions().addAll(this.createFields(fields));
        return objectTypeDefinition;
    }

    private List<FieldDefinition> createFields(List<Map<String, Object>> fields) {
        ArrayList<FieldDefinition> result = new ArrayList<FieldDefinition>();
        for (Map<String, Object> field : fields) {
            FieldDefinition fieldDefinition = new FieldDefinition((String)field.get("name"));
            fieldDefinition.setComments(this.toComment((String)field.get("description")));
            fieldDefinition.setType(this.createTypeIndirection((Map)field.get("type")));
            this.createDeprecatedDirective(field, fieldDefinition.getDirectives());
            List args = (List)field.get("args");
            List<InputValueDefinition> inputValueDefinitions = this.createInputValueDefinitions(args);
            fieldDefinition.getInputValueDefinitions().addAll(inputValueDefinitions);
            result.add(fieldDefinition);
        }
        return result;
    }

    private void createDeprecatedDirective(Map<String, Object> field, List<Directive> directives) {
        if (((Boolean)field.get("isDeprecated")).booleanValue()) {
            String reason = (String)field.get("deprecationReason");
            if (reason == null) {
                reason = "No longer supported";
            }
            Argument reasonArg = new Argument("reason", new StringValue(reason));
            Directive deprecated = new Directive("deprecated", Collections.singletonList(reasonArg));
            directives.add(deprecated);
        }
    }

    private List<InputValueDefinition> createInputValueDefinitions(List<Map<String, Object>> args) {
        ArrayList<InputValueDefinition> result = new ArrayList<InputValueDefinition>();
        for (Map<String, Object> arg : args) {
            Type argType = this.createTypeIndirection((Map)arg.get("type"));
            InputValueDefinition inputValueDefinition = new InputValueDefinition((String)arg.get("name"), argType);
            inputValueDefinition.setComments(this.toComment((String)arg.get("description")));
            if (arg.get("defaultValue") != null) {
                StringValue defaultValue = new StringValue((String)arg.get("defaultValue"));
                inputValueDefinition.setDefaultValue(defaultValue);
            }
            result.add(inputValueDefinition);
        }
        return result;
    }

    private Type createTypeIndirection(Map<String, Object> type) {
        String kind;
        switch (kind = (String)type.get("kind")) {
            case "INTERFACE": 
            case "OBJECT": 
            case "UNION": 
            case "ENUM": 
            case "INPUT_OBJECT": 
            case "SCALAR": {
                return new TypeName((String)type.get("name"));
            }
            case "NON_NULL": {
                return new NonNullType(this.createTypeIndirection((Map)type.get("ofType")));
            }
            case "LIST": {
                return new ListType(this.createTypeIndirection((Map)type.get("ofType")));
            }
        }
        return (Type)Assert.assertShouldNeverHappen("Unknown kind " + kind);
    }

    private List<Comment> toComment(String description) {
        if (description == null) {
            return Collections.emptyList();
        }
        Comment comment = new Comment(description, new SourceLocation(1, 1));
        return Collections.singletonList(comment);
    }
}

