/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.preparsed;

import graphql.GraphQLError;
import graphql.language.Document;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PreparsedDocumentEntry {
    private final Document document;
    private final List<? extends GraphQLError> errors;

    public PreparsedDocumentEntry(Document document) {
        Objects.requireNonNull(document);
        this.document = document;
        this.errors = null;
    }

    public PreparsedDocumentEntry(List<? extends GraphQLError> errors) {
        Objects.requireNonNull(errors);
        this.document = null;
        this.errors = errors;
    }

    public PreparsedDocumentEntry(GraphQLError error) {
        this(Collections.singletonList(Objects.requireNonNull(error)));
    }

    public Document getDocument() {
        return this.document;
    }

    public List<? extends GraphQLError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }
}

