/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.NoOpInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.instrumentation.parameters.InstrumentationDataFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoaderDispatcherInstrumentation
extends NoOpInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(DataLoaderDispatcherInstrumentation.class);
    private final DataLoaderRegistry dataLoaderRegistry;
    private final DataLoaderDispatcherInstrumentationOptions options;

    public DataLoaderDispatcherInstrumentation(DataLoaderRegistry dataLoaderRegistry) {
        this(dataLoaderRegistry, DataLoaderDispatcherInstrumentationOptions.newOptions());
    }

    public DataLoaderDispatcherInstrumentation(DataLoaderRegistry dataLoaderRegistry, DataLoaderDispatcherInstrumentationOptions options) {
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.options = options;
    }

    @Override
    public InstrumentationState createState() {
        return new CallStack();
    }

    private void dispatch() {
        log.debug("Dispatching data loaders ({})", (Object)this.dataLoaderRegistry.getKeys());
        this.dataLoaderRegistry.dispatchAll();
    }

    private void dispatchIfNeeded(CallStack callStack) {
        if (!callStack.isInList()) {
            this.dispatch();
        }
    }

    @Override
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        CallStack callStack = (CallStack)parameters.getInstrumentationState();
        if (callStack.isAggressivelyBatching()) {
            return dataFetcher;
        }
        return environment -> {
            Object obj = dataFetcher.get(environment);
            this.dispatch();
            return obj;
        };
    }

    @Override
    public InstrumentationContext<CompletableFuture<ExecutionResult>> beginDataFetchDispatch(InstrumentationDataFetchParameters parameters) {
        ExecutionStrategy queryStrategy = parameters.getExecutionContext().getQueryStrategy();
        if (!(queryStrategy instanceof AsyncExecutionStrategy)) {
            CallStack callStack = (CallStack)parameters.getInstrumentationState();
            callStack.setAggressivelyBatching(false);
        }
        return (result, t) -> this.dispatch();
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginDataFetch(InstrumentationDataFetchParameters parameters) {
        return super.beginDataFetch(parameters);
    }

    @Override
    public InstrumentationContext<Map<String, List<Field>>> beginFields(InstrumentationExecutionStrategyParameters parameters) {
        CallStack callStack = (CallStack)parameters.getInstrumentationState();
        return (result, t) -> this.dispatchIfNeeded(callStack);
    }

    @Override
    public InstrumentationContext<CompletableFuture<ExecutionResult>> beginCompleteFieldList(InstrumentationFieldCompleteParameters parameters) {
        CallStack callStack = (CallStack)parameters.getInstrumentationState();
        callStack.enterList();
        return (result, t) -> {
            callStack.exitList();
            this.dispatchIfNeeded(callStack);
        };
    }

    @Override
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        if (!this.options.isIncludeStatistics()) {
            return CompletableFuture.completedFuture(executionResult);
        }
        Map<Object, Object> currentExt = executionResult.getExtensions();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.putAll(currentExt == null ? Collections.emptyMap() : currentExt);
        Map<Object, Object> dataLoaderStats = this.buildStatsMap();
        statsMap.put("dataloader", dataLoaderStats);
        log.debug("Data loader stats : {}", dataLoaderStats);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), statsMap));
    }

    private Map<Object, Object> buildStatsMap() {
        Statistics allStats = this.dataLoaderRegistry.getStatistics();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.put("overall-statistics", allStats.toMap());
        LinkedHashMap<String, Map> individualStatsMap = new LinkedHashMap<String, Map>();
        for (String dlKey : this.dataLoaderRegistry.getKeys()) {
            DataLoader dl = this.dataLoaderRegistry.getDataLoader(dlKey);
            Statistics statistics = dl.getStatistics();
            individualStatsMap.put(dlKey, statistics.toMap());
        }
        statsMap.put("individual-statistics", individualStatsMap);
        return statsMap;
    }

    private static class CallStack
    implements InstrumentationState {
        private boolean aggressivelyBatching = true;
        private final Deque<Boolean> stack = new ArrayDeque<Boolean>();

        private CallStack() {
        }

        private boolean isAggressivelyBatching() {
            return this.aggressivelyBatching;
        }

        private void setAggressivelyBatching(boolean aggressivelyBatching) {
            this.aggressivelyBatching = aggressivelyBatching;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enterList() {
            CallStack callStack = this;
            synchronized (callStack) {
                this.stack.push(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exitList() {
            CallStack callStack = this;
            synchronized (callStack) {
                if (!this.stack.isEmpty()) {
                    this.stack.pop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isInList() {
            CallStack callStack = this;
            synchronized (callStack) {
                if (this.stack.isEmpty()) {
                    return false;
                }
                return this.stack.peek();
            }
        }

        public String toString() {
            return "isInList=" + this.isInList();
        }
    }
}

