/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class ValuesResolver {
    public Map<String, Object> coerceArgumentValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> variableValues) {
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            Object coercedValue;
            String variableName = variableDefinition.getName();
            GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
            if (!variableValues.containsKey(variableName)) {
                Value defaultValue = variableDefinition.getDefaultValue();
                if (defaultValue != null) {
                    coercedValue = this.coerceValueAst(variableType, variableDefinition.getDefaultValue(), null);
                    coercedValues.put(variableName, coercedValue);
                    continue;
                }
                if (!this.isNonNullType(variableType)) continue;
                throw new NonNullableValueCoercedAsNullException(variableDefinition, variableType);
            }
            Object value = variableValues.get(variableName);
            coercedValue = this.getVariableValue(variableDefinition, variableType, value);
            coercedValues.put(variableName, coercedValue);
        }
        return coercedValues;
    }

    private Object getVariableValue(VariableDefinition variableDefinition, GraphQLType variableType, Object value) {
        if (value == null && variableDefinition.getDefaultValue() != null) {
            return this.coerceValueAst(variableType, variableDefinition.getDefaultValue(), null);
        }
        return this.coerceValue(variableDefinition, variableType, value);
    }

    private boolean isNonNullType(GraphQLType variableType) {
        return variableType instanceof GraphQLNonNull;
    }

    public Map<String, Object> getArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments, Map<String, Object> variables) {
        if (argumentTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, Argument> argumentMap = this.argumentMap(arguments);
        for (GraphQLArgument fieldArgument : argumentTypes) {
            String argName = fieldArgument.getName();
            Argument argument = argumentMap.get(argName);
            Object value = argument != null ? this.coerceValueAst(fieldArgument.getType(), argument.getValue(), variables) : fieldArgument.getDefaultValue();
            if (!argumentMap.containsKey(argName) && value == null) continue;
            result.put(argName, value);
        }
        return result;
    }

    private Map<String, Argument> argumentMap(List<Argument> arguments) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>();
        for (Argument argument : arguments) {
            result.put(argument.getName(), argument);
        }
        return result;
    }

    private Object coerceValue(VariableDefinition variableDefinition, GraphQLType graphQLType, Object value) {
        if (graphQLType instanceof GraphQLNonNull) {
            Object returnValue = this.coerceValue(variableDefinition, ((GraphQLNonNull)graphQLType).getWrappedType(), value);
            if (returnValue == null) {
                throw new NonNullableValueCoercedAsNullException(variableDefinition, graphQLType);
            }
            return returnValue;
        }
        if (value == null) {
            return null;
        }
        if (graphQLType instanceof GraphQLScalarType) {
            return this.coerceValueForScalar((GraphQLScalarType)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLEnumType) {
            return this.coerceValueForEnum((GraphQLEnumType)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLList) {
            return this.coerceValueForList(variableDefinition, (GraphQLList)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLInputObjectType) {
            if (value instanceof Map) {
                return this.coerceValueForInputObjectType(variableDefinition, (GraphQLInputObjectType)graphQLType, (Map)value);
            }
            throw new CoercingParseValueException("Variables for GraphQLInputObjectType must be an instance of a Map according to the graphql specification.  The offending object was a " + value.getClass().getName());
        }
        return Assert.assertShouldNeverHappen("unhandled type " + graphQLType);
    }

    private Object coerceValueForInputObjectType(VariableDefinition variableDefinition, GraphQLInputObjectType inputObjectType, Map<String, Object> input) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List<GraphQLInputObjectField> fields = inputObjectType.getFields();
        List fieldNames = fields.stream().map(GraphQLInputObjectField::getName).collect(Collectors.toList());
        for (String inputFieldName : input.keySet()) {
            if (fieldNames.contains(inputFieldName)) continue;
            throw new InputMapDefinesTooManyFieldsException(inputObjectType, inputFieldName);
        }
        for (GraphQLInputObjectField inputField : fields) {
            if (!input.containsKey(inputField.getName()) && !this.alwaysHasValue(inputField)) continue;
            Object value = this.coerceValue(variableDefinition, inputField.getType(), input.get(inputField.getName()));
            result.put(inputField.getName(), value == null ? inputField.getDefaultValue() : value);
        }
        return result;
    }

    private boolean alwaysHasValue(GraphQLInputObjectField inputField) {
        return inputField.getDefaultValue() != null || inputField.getType() instanceof GraphQLNonNull;
    }

    private Object coerceValueForScalar(GraphQLScalarType graphQLScalarType, Object value) {
        return graphQLScalarType.getCoercing().parseValue(value);
    }

    private Object coerceValueForEnum(GraphQLEnumType graphQLEnumType, Object value) {
        return graphQLEnumType.getCoercing().parseValue(value);
    }

    private List coerceValueForList(VariableDefinition variableDefinition, GraphQLList graphQLList, Object value) {
        if (value instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object val : (Iterable)value) {
                result.add(this.coerceValue(variableDefinition, graphQLList.getWrappedType(), val));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValue(variableDefinition, graphQLList.getWrappedType(), value));
    }

    private Object coerceValueAst(GraphQLType type, Value inputValue, Map<String, Object> variables) {
        if (inputValue instanceof VariableReference) {
            return variables.get(((VariableReference)inputValue).getName());
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().parseLiteral(inputValue);
        }
        if (type instanceof GraphQLNonNull) {
            return this.coerceValueAst(((GraphQLNonNull)type).getWrappedType(), inputValue, variables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.coerceValueAstForInputObject((GraphQLInputObjectType)type, (ObjectValue)inputValue, variables);
        }
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).getCoercing().parseLiteral(inputValue);
        }
        if (type instanceof GraphQLList) {
            return this.coerceValueAstForList((GraphQLList)type, inputValue, variables);
        }
        return null;
    }

    private Object coerceValueAstForList(GraphQLList graphQLList, Value value, Map<String, Object> variables) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value singleValue : arrayValue.getValues()) {
                result.add(this.coerceValueAst(graphQLList.getWrappedType(), singleValue, variables));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValueAst(graphQLList.getWrappedType(), value, variables));
    }

    private Object coerceValueAstForInputObject(GraphQLInputObjectType type, ObjectValue inputValue, Map<String, Object> variables) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, ObjectField> inputValueFieldsByName = this.mapObjectValueFieldsByName(inputValue);
        for (GraphQLInputObjectField inputTypeField : type.getFields()) {
            if (inputValueFieldsByName.containsKey(inputTypeField.getName())) {
                boolean putObjectInMap = true;
                ObjectField field = inputValueFieldsByName.get(inputTypeField.getName());
                Value fieldInputValue = field.getValue();
                Object fieldObject = null;
                if (fieldInputValue instanceof VariableReference) {
                    String varName = ((VariableReference)fieldInputValue).getName();
                    if (!variables.containsKey(varName)) {
                        putObjectInMap = false;
                    } else {
                        fieldObject = variables.get(varName);
                    }
                } else {
                    fieldObject = this.coerceValueAst(inputTypeField.getType(), fieldInputValue, variables);
                }
                if (fieldObject == null && !field.getValue().isEqualTo(NullValue.Null)) {
                    fieldObject = inputTypeField.getDefaultValue();
                }
                if (putObjectInMap) {
                    result.put(field.getName(), fieldObject);
                    continue;
                }
                this.assertNonNullInputField(inputTypeField);
                continue;
            }
            if (inputTypeField.getDefaultValue() != null) {
                result.put(inputTypeField.getName(), inputTypeField.getDefaultValue());
                continue;
            }
            this.assertNonNullInputField(inputTypeField);
        }
        return result;
    }

    private void assertNonNullInputField(GraphQLInputObjectField inputTypeField) {
        if (inputTypeField.getType() instanceof GraphQLNonNull) {
            throw new NonNullableValueCoercedAsNullException(inputTypeField);
        }
    }

    private Map<String, ObjectField> mapObjectValueFieldsByName(ObjectValue inputValue) {
        LinkedHashMap<String, ObjectField> inputValueFieldsByName = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : inputValue.getObjectFields()) {
            inputValueFieldsByName.put(objectField.getName(), objectField);
        }
        return inputValueFieldsByName;
    }
}

