/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.reactive.CompletionStageMappingPublisher;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public class SubscriptionExecutionStrategy
extends ExecutionStrategy {
    public SubscriptionExecutionStrategy() {
    }

    public SubscriptionExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        super(dataFetcherExceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        CompletableFuture<Publisher<Object>> sourceEventStream = this.createSourceEventStream(executionContext, parameters);
        return sourceEventStream.thenApply(publisher -> {
            if (publisher == null) {
                return new ExecutionResultImpl(null, executionContext.getErrors());
            }
            CompletionStageMappingPublisher mapSourceToResponse = new CompletionStageMappingPublisher((Publisher<Object>)publisher, eventPayload -> this.executeSubscriptionEvent(executionContext, parameters, eventPayload));
            return new ExecutionResultImpl(mapSourceToResponse, executionContext.getErrors());
        });
    }

    private CompletableFuture<Publisher<Object>> createSourceEventStream(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        ExecutionStrategyParameters newParameters = this.firstFieldOfSubscriptionSelection(parameters);
        CompletableFuture<Object> fieldFetched = this.fetchField(executionContext, newParameters);
        return fieldFetched.thenApply(publisher -> {
            if (publisher != null) {
                Assert.assertTrue(publisher instanceof Publisher, "You data fetcher must return a Publisher of events when using graphql subscriptions");
            }
            return (Publisher)publisher;
        });
    }

    private CompletableFuture<ExecutionResult> executeSubscriptionEvent(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object eventPayload) {
        ExecutionContext newExecutionContext = executionContext.transform(builder -> builder.root(eventPayload));
        ExecutionStrategyParameters newParameters = this.firstFieldOfSubscriptionSelection(parameters);
        return this.completeField(newExecutionContext, newParameters, eventPayload);
    }

    private ExecutionStrategyParameters firstFieldOfSubscriptionSelection(ExecutionStrategyParameters parameters) {
        Map<String, List<Field>> fields = parameters.fields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        List<Field> firstField = fields.get(fieldNames.get(0));
        ExecutionPath fieldPath = parameters.path().segment(firstField.get(0).getName());
        return parameters.transform(builder -> builder.field(firstField).path(fieldPath));
    }
}

