/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionTypeInfo;

public class NonNullableFieldWasNullException
extends RuntimeException {
    private final ExecutionTypeInfo typeInfo;
    private final ExecutionPath path;

    public NonNullableFieldWasNullException(ExecutionTypeInfo typeInfo, ExecutionPath path) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(typeInfo), Assert.assertNotNull(path)));
        this.typeInfo = typeInfo;
        this.path = path;
    }

    public NonNullableFieldWasNullException(NonNullableFieldWasNullException previousException) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(previousException.typeInfo.getParentTypeInfo()), Assert.assertNotNull(previousException.typeInfo.getParentTypeInfo().getPath())), previousException);
        this.typeInfo = previousException.typeInfo.getParentTypeInfo();
        this.path = previousException.typeInfo.getParentTypeInfo().getPath();
    }

    private static String mkMessage(ExecutionTypeInfo typeInfo, ExecutionPath path) {
        if (typeInfo.hasParentType()) {
            return String.format("Cannot return null for non-nullable type: '%s' within parent '%s' (%s)", typeInfo.getType().getName(), typeInfo.getParentTypeInfo().getType().getName(), path);
        }
        return String.format("Cannot return null for non-nullable type: '%s' (%s)", typeInfo.getType().getName(), path);
    }

    public ExecutionTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return "NonNullableFieldWasNullException{ path=" + this.path + " typeInfo=" + this.typeInfo + '}';
    }
}

