/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Stack;

@PublicApi
public class ExecutionTypeInfo {
    private final GraphQLType type;
    private final GraphQLFieldDefinition fieldDefinition;
    private final ExecutionPath path;
    private final boolean typeIsNonNull;
    private final ExecutionTypeInfo parentType;

    private ExecutionTypeInfo(GraphQLType type, GraphQLFieldDefinition fieldDefinition, ExecutionPath path, ExecutionTypeInfo parentType, boolean nonNull) {
        this.fieldDefinition = fieldDefinition;
        this.path = path;
        this.parentType = parentType;
        this.type = type;
        this.typeIsNonNull = nonNull;
        Assert.assertNotNull(this.type, "you must provide a graphql type");
    }

    public GraphQLType getType() {
        return this.type;
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    public <T extends GraphQLType> T castType(Class<T> clazz) {
        return (T)((GraphQLType)clazz.cast(this.type));
    }

    public boolean isNonNullType() {
        return this.typeIsNonNull;
    }

    public boolean isListType() {
        return this.type instanceof GraphQLList;
    }

    public ExecutionTypeInfo getParentTypeInfo() {
        return this.parentType;
    }

    public boolean hasParentType() {
        return this.parentType != null;
    }

    public ExecutionTypeInfo treatAs(GraphQLType newType) {
        return new ExecutionTypeInfo(ExecutionTypeInfo.unwrapNonNull(newType), this.fieldDefinition, this.path, this.parentType, this.typeIsNonNull);
    }

    public static Stack<GraphQLType> unwrapType(GraphQLType type) {
        type = Assert.assertNotNull(type);
        Stack<GraphQLType> decoration = new Stack<GraphQLType>();
        while (true) {
            decoration.push(type);
            if (type instanceof GraphQLNonNull) {
                type = ((GraphQLNonNull)type).getWrappedType();
                continue;
            }
            if (!(type instanceof GraphQLList)) break;
            type = ((GraphQLList)type).getWrappedType();
        }
        return decoration;
    }

    public static GraphQLType unwrapBaseType(GraphQLType type) {
        return ExecutionTypeInfo.unwrapType(type).pop();
    }

    public String toAst() {
        GraphQLType type = this.getType();
        if (this.isNonNullType()) {
            type = GraphQLNonNull.nonNull(type);
        }
        return GraphQLTypeUtil.getUnwrappedTypeName(type);
    }

    public String toString() {
        return "ExecutionTypeInfo{ path=" + this.path + ", type=" + this.type + ", parentType=" + this.parentType + ", typeIsNonNull=" + this.typeIsNonNull + ", fieldDefinition=" + this.fieldDefinition + '}';
    }

    private static GraphQLType unwrapNonNull(GraphQLType type) {
        while (type instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getWrappedType();
        }
        return type;
    }

    public static Builder newTypeInfo() {
        return new Builder();
    }

    public static class Builder {
        GraphQLType type;
        ExecutionTypeInfo parentType;
        GraphQLFieldDefinition fieldDefinition;
        ExecutionPath executionPath;

        private Builder() {
        }

        public Builder type(GraphQLType type) {
            this.type = type;
            return this;
        }

        public Builder parentInfo(ExecutionTypeInfo typeInfo) {
            this.parentType = typeInfo;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder path(ExecutionPath executionPath) {
            this.executionPath = executionPath;
            return this;
        }

        public ExecutionTypeInfo build() {
            if (this.type instanceof GraphQLNonNull) {
                return new ExecutionTypeInfo(ExecutionTypeInfo.unwrapNonNull(this.type), this.fieldDefinition, this.executionPath, this.parentType, true);
            }
            return new ExecutionTypeInfo(this.type, this.fieldDefinition, this.executionPath, this.parentType, false);
        }
    }
}

