/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TypeResolutionEnvironment;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.TypeResolutionParameters;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.field().get(0));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = instrumentation.beginField(new InstrumentationFieldParameters(executionContext, fieldDef, this.fieldTypeInfo(parameters, fieldDef)));
        CompletionStage result = this.fetchField(executionContext, parameters).thenCompose(fetchedValue -> this.completeField(executionContext, parameters, fetchedValue));
        ((CompletableFuture)result).whenComplete(fieldCtx::onEnd);
        return result;
    }

    protected CompletableFuture<Object> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<Object> fetchedValue;
        Field field = parameters.field().get(0);
        GraphQLObjectType parentType = parameters.typeInfo().castType(GraphQLObjectType.class);
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext, fieldType, parameters.field());
        ExecutionTypeInfo fieldTypeInfo = this.fieldTypeInfo(parameters, fieldDef);
        DataFetchingEnvironment environment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(executionContext).source(parameters.source()).arguments(argumentValues).fieldDefinition(fieldDef).fields(parameters.field()).fieldType(fieldType).fieldTypeInfo(fieldTypeInfo).parentType(parentType).selectionSet(fieldCollector).build();
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, fieldDef, environment);
        InstrumentationContext<Object> fetchCtx = instrumentation.beginFieldFetch(instrumentationFieldFetchParams);
        DataFetcher<?> dataFetcher = fieldDef.getDataFetcher();
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams);
        ExecutionId executionId = executionContext.getExecutionId();
        try {
            log.debug("'{}' fetching field '{}' using data fetcher '{}'...", new Object[]{executionId, fieldTypeInfo.getPath(), dataFetcher.getClass().getName()});
            Object fetchedValueRaw = dataFetcher.get(environment);
            log.debug("'{}' field '{}' fetch returned '{}'", new Object[]{executionId, fieldTypeInfo.getPath(), fetchedValueRaw == null ? "null" : fetchedValueRaw.getClass().getName()});
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            log.debug(String.format("'%s', field '%s' fetch threw exception", executionId, fieldTypeInfo.getPath()), (Throwable)e);
            fetchedValue = new CompletableFuture();
            fetchedValue.completeExceptionally(e);
        }
        return fetchedValue.handle((result, exception) -> {
            fetchCtx.onEnd(result, (Throwable)exception);
            if (exception != null) {
                this.handleFetchingException(executionContext, parameters, field, fieldDef, argumentValues, environment, (Throwable)exception);
                return null;
            }
            return result;
        });
    }

    private void handleFetchingException(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field, GraphQLFieldDefinition fieldDef, Map<String, Object> argumentValues, DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().executionContext(executionContext).dataFetchingEnvironment(environment).argumentValues(argumentValues).field(field).fieldDefinition(fieldDef).path(parameters.path()).exception(e).build();
        this.dataFetcherExceptionHandler.accept(handlerParameters);
    }

    protected CompletableFuture<ExecutionResult> completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object fetchedValue) {
        Field field = parameters.field().get(0);
        GraphQLObjectType parentType = parameters.typeInfo().castType(GraphQLObjectType.class);
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        InstrumentationContext<CompletableFuture<ExecutionResult>> ctx = executionContext.getInstrumentation().beginCompleteField(new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, this.fieldTypeInfo(parameters, fieldDef)));
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        ExecutionTypeInfo fieldTypeInfo = this.fieldTypeInfo(parameters, fieldDef);
        log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)fieldTypeInfo.getPath());
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, fieldTypeInfo);
        ExecutionStrategyParameters newParameters = ExecutionStrategyParameters.newParameters().typeInfo(fieldTypeInfo).field(parameters.field()).fields(parameters.fields()).arguments(argumentValues).source(fetchedValue).nonNullFieldValidator(nonNullableFieldValidator).path(parameters.path()).build();
        CompletableFuture<ExecutionResult> cf = this.completeValue(executionContext, newParameters);
        ctx.onEnd(cf, null);
        return cf;
    }

    protected CompletableFuture<ExecutionResult> completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = parameters.typeInfo();
        Object result = this.unboxPossibleOptional(parameters.source());
        GraphQLType fieldType = typeInfo.getType();
        if (result == null) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(parameters.nonNullFieldValidator().validate(parameters.path(), null), null));
        }
        if (fieldType instanceof GraphQLList) {
            return this.completeValueForList(executionContext, parameters, this.toIterable(result));
        }
        if (fieldType instanceof GraphQLScalarType) {
            return this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
        }
        if (fieldType instanceof GraphQLEnumType) {
            return this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
        }
        GraphQLObjectType resolvedType = this.resolveType(executionContext, parameters, fieldType);
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        Map<String, List<Field>> subFields = this.fieldCollector.collectFields(collectorParameters, parameters.field());
        ExecutionTypeInfo newTypeInfo = typeInfo.treatAs(resolvedType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newTypeInfo);
        ExecutionStrategyParameters newParameters = ExecutionStrategyParameters.newParameters().typeInfo(newTypeInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).path(parameters.path()).source(result).build();
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    protected Object unboxPossibleOptional(Object result) {
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            result = optional.isPresent() ? optional.get() : null;
        }
        return result;
    }

    protected Iterable<Object> toIterable(Object result) {
        if (result.getClass().isArray()) {
            return IntStream.range(0, Array.getLength(result)).mapToObj(i -> Array.get(result, i)).collect(Collectors.toList());
        }
        return (Iterable)result;
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        GraphQLObjectType resolvedType;
        if (fieldType instanceof GraphQLInterfaceType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLInterfaceType((GraphQLInterfaceType)fieldType).field(parameters.field().get(0)).value(parameters.source()).argumentValues(parameters.arguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForInterface(resolutionParams);
        } else if (fieldType instanceof GraphQLUnionType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLUnionType((GraphQLUnionType)fieldType).field(parameters.field().get(0)).value(parameters.source()).argumentValues(parameters.arguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForUnion(resolutionParams);
        } else {
            resolvedType = (GraphQLObjectType)fieldType;
        }
        return resolvedType;
    }

    protected GraphQLObjectType resolveTypeForInterface(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLInterfaceType(), params.getSchema(), params.getContext());
        GraphQLObjectType result = params.getGraphQLInterfaceType().getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(params.getGraphQLInterfaceType());
        }
        return result;
    }

    protected GraphQLObjectType resolveTypeForUnion(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLUnionType(), params.getSchema(), params.getContext());
        GraphQLObjectType result = params.getGraphQLUnionType().getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(params.getGraphQLUnionType());
        }
        return result;
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        serialized = parameters.nonNullFieldValidator().validate(parameters.path(), serialized);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        serialized = parameters.nonNullFieldValidator().validate(parameters.path(), serialized);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.path(), e);
        log.warn(error.getMessage(), (Throwable)e);
        context.addError(error, parameters.path());
        return null;
    }

    protected CompletableFuture<ExecutionResult> completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        ExecutionTypeInfo typeInfo = parameters.typeInfo();
        GraphQLList fieldType = typeInfo.castType(GraphQLList.class);
        GraphQLFieldDefinition fieldDef = parameters.typeInfo().getFieldDefinition();
        InstrumentationContext<CompletableFuture<ExecutionResult>> ctx = executionContext.getInstrumentation().beginCompleteFieldList(new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, this.fieldTypeInfo(parameters, fieldDef)));
        CompletableFuture resultsFuture = Async.each(iterableValues, (item, index) -> {
            ExecutionPath indexedPath = parameters.path().segment((int)index);
            ExecutionTypeInfo wrappedTypeInfo = ExecutionTypeInfo.newTypeInfo().parentInfo(typeInfo).type(fieldType.getWrappedType()).path(indexedPath).fieldDefinition(fieldDef).build();
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, wrappedTypeInfo);
            ExecutionStrategyParameters newParameters = ExecutionStrategyParameters.newParameters().typeInfo(wrappedTypeInfo).fields(parameters.fields()).nonNullFieldValidator(nonNullableFieldValidator).path(indexedPath).field(parameters.field()).source(item).build();
            return this.completeValue(executionContext, newParameters);
        });
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList();
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            overallResult.complete(new ExecutionResultImpl(completedResults, null));
        });
        ctx.onEnd(overallResult, null);
        return overallResult;
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = parameters.typeInfo().castType(GraphQLObjectType.class);
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = e.getTypeInfo();
        if (typeInfo.hasParentType() && typeInfo.getParentTypeInfo().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = e.getTypeInfo();
        if (typeInfo.hasParentType() && typeInfo.getParentTypeInfo().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected void handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        if (e instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)e, result);
            if (!result.isDone()) {
                result.complete(new ExecutionResultImpl(null, executionContext.getErrors()));
            }
        } else if (e instanceof CompletionException && e.getCause() instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)e.getCause(), result);
            if (!result.isDone()) {
                result.complete(new ExecutionResultImpl(null, executionContext.getErrors()));
            }
        } else {
            result.completeExceptionally(e);
        }
    }

    protected ExecutionTypeInfo fieldTypeInfo(ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition) {
        GraphQLOutputType fieldType = fieldDefinition.getType();
        return ExecutionTypeInfo.newTypeInfo().type(fieldType).fieldDefinition(fieldDefinition).path(parameters.path()).parentInfo(parameters.typeInfo()).build();
    }
}

