/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ExecutionContext {
    private final GraphQLSchema graphQLSchema;
    private final ExecutionId executionId;
    private final InstrumentationState instrumentationState;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final OperationDefinition operationDefinition;
    private final Document document;
    private final Map<String, Object> variables;
    private final Object root;
    private final Object context;
    private final Instrumentation instrumentation;
    private final Map<String, GraphQLError> errors = new LinkedHashMap<String, GraphQLError>();

    public ExecutionContext(Instrumentation instrumentation, ExecutionId executionId, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Map<String, FragmentDefinition> fragmentsByName, Document document, OperationDefinition operationDefinition, Map<String, Object> variables, Object context, Object root) {
        this(instrumentation, executionId, graphQLSchema, instrumentationState, queryStrategy, mutationStrategy, subscriptionStrategy, fragmentsByName, document, operationDefinition, variables, context, root, Collections.emptyMap());
    }

    ExecutionContext(Instrumentation instrumentation, ExecutionId executionId, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Map<String, FragmentDefinition> fragmentsByName, Document document, OperationDefinition operationDefinition, Map<String, Object> variables, Object context, Object root, Map<String, GraphQLError> startingErrors) {
        this.graphQLSchema = graphQLSchema;
        this.executionId = executionId;
        this.instrumentationState = instrumentationState;
        this.queryStrategy = queryStrategy;
        this.mutationStrategy = mutationStrategy;
        this.subscriptionStrategy = subscriptionStrategy;
        this.fragmentsByName = fragmentsByName;
        this.document = document;
        this.operationDefinition = operationDefinition;
        this.variables = variables;
        this.context = context;
        this.root = root;
        this.instrumentation = instrumentation;
        this.errors.putAll(startingErrors);
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public InstrumentationState getInstrumentationState() {
        return this.instrumentationState;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.fragmentsByName;
    }

    public Document getDocument() {
        return this.document;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getContext() {
        return this.context;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public FragmentDefinition getFragment(String name) {
        return this.fragmentsByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(GraphQLError error, ExecutionPath path) {
        Map<String, GraphQLError> map = this.errors;
        synchronized (map) {
            String key = path.toString();
            if (!this.errors.containsKey(key)) {
                this.errors.put(key, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphQLError> getErrors() {
        Map<String, GraphQLError> map = this.errors;
        synchronized (map) {
            return new ArrayList<GraphQLError>(this.errors.values());
        }
    }

    Map<String, GraphQLError> getErrorMap() {
        return this.errors;
    }

    public ExecutionStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public ExecutionStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public ExecutionStrategy getSubscriptionStrategy() {
        return this.subscriptionStrategy;
    }

    public ExecutionContext transform(Consumer<ExecutionContextBuilder> builderConsumer) {
        ExecutionContextBuilder builder = ExecutionContextBuilder.newExecutionContextBuilder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }
}

