/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class AsyncSerialExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncSerialExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncSerialExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext);
        InstrumentationContext<CompletableFuture<ExecutionResult>> executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        Map<String, List<Field>> fields = parameters.fields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        InstrumentationContext<Map<String, List<Field>>> beginFieldsCtx = instrumentation.beginFields(instrumentationParameters);
        CompletableFuture resultsFuture = Async.eachSequentially(fieldNames, (fieldName, index, prevResults) -> {
            List currentField = (List)fields.get(fieldName);
            ExecutionPath fieldPath = parameters.path().segment((String)fieldName);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath));
            return this.resolveField(executionContext, newParameters);
        });
        beginFieldsCtx.onEnd(fields, null);
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        BiConsumer<List<ExecutionResult>, Throwable> listThrowableBiConsumer = this.handleResults(executionContext, fieldNames, overallResult);
        resultsFuture.whenComplete(listThrowableBiConsumer);
        executionStrategyCtx.onEnd(overallResult, null);
        return overallResult;
    }
}

