/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext);
        InstrumentationContext<CompletableFuture<ExecutionResult>> executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        InstrumentationContext<Map<String, List<Field>>> beginFieldsCtx = instrumentation.beginFields(instrumentationParameters);
        Map<String, List<Field>> fields = parameters.fields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        ArrayList futures = new ArrayList();
        for (String fieldName : fieldNames) {
            List<Field> currentField = fields.get(fieldName);
            ExecutionPath fieldPath = parameters.path().segment(fieldName);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath));
            CompletableFuture<ExecutionResult> future = this.resolveField(executionContext, newParameters);
            futures.add(future);
        }
        beginFieldsCtx.onEnd(fields, null);
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        Async.each(futures).whenComplete(this.handleResults(executionContext, fieldNames, overallResult));
        executionStrategyCtx.onEnd(overallResult, null);
        return overallResult;
    }
}

