/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.Internal;
import graphql.analysis.QueryReducer;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorEnvironment;
import graphql.execution.ConditionalNodes;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import java.util.LinkedHashMap;
import java.util.Map;

@Internal
public class QueryTraversal {
    private final OperationDefinition operationDefinition;
    private final GraphQLSchema schema;
    private Map<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
    private final Map<String, Object> variables;
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();
    private final ValuesResolver valuesResolver = new ValuesResolver();
    private final SchemaUtil schemaUtil = new SchemaUtil();

    public QueryTraversal(GraphQLSchema schema, Document document, String operation, Map<String, Object> variables) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operation);
        this.operationDefinition = getOperationResult.operationDefinition;
        this.fragmentsByName = getOperationResult.fragmentsByName;
        this.schema = schema;
        this.variables = variables;
    }

    public void visitPostOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, this.operationDefinition.getSelectionSet(), this.getRootType(), null, false);
    }

    public void visitPreOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, this.operationDefinition.getSelectionSet(), this.getRootType(), null, true);
    }

    private GraphQLObjectType getRootType() {
        if (this.operationDefinition.getOperation() == OperationDefinition.Operation.MUTATION) {
            return Assert.assertNotNull(this.schema.getMutationType());
        }
        if (this.operationDefinition.getOperation() == OperationDefinition.Operation.QUERY) {
            return Assert.assertNotNull(this.schema.getQueryType());
        }
        if (this.operationDefinition.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            return Assert.assertNotNull(this.schema.getSubscriptionType());
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen();
    }

    public <T> T reducePostOrder(QueryReducer<T> queryReducer, T initialValue) {
        Object[] acc = new Object[]{initialValue};
        this.visitPostOrder(env -> {
            acc[0] = queryReducer.reduceField(env, acc[0]);
        });
        return (T)acc[0];
    }

    public <T> T reducePreOrder(QueryReducer<T> queryReducer, T initialValue) {
        Object[] acc = new Object[]{initialValue};
        this.visitPreOrder(env -> {
            acc[0] = queryReducer.reduceField(env, acc[0]);
        });
        return (T)acc[0];
    }

    private void visitImpl(QueryVisitor visitor, SelectionSet selectionSet, GraphQLCompositeType type, QueryVisitorEnvironment parent, boolean preOrder) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.schema, type, ((Field)selection).getName());
                this.visitField(visitor, (Field)selection, fieldDefinition, type, parent, preOrder);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.visitInlineFragment(visitor, (InlineFragment)selection, type, parent, preOrder);
                continue;
            }
            if (!(selection instanceof FragmentSpread)) continue;
            this.visitFragmentSpread(visitor, (FragmentSpread)selection, parent, preOrder);
        }
    }

    private void visitFragmentSpread(QueryVisitor visitor, FragmentSpread fragmentSpread, QueryVisitorEnvironment parent, boolean preOrder) {
        if (!this.conditionalNodes.shouldInclude(this.variables, fragmentSpread.getDirectives())) {
            return;
        }
        FragmentDefinition fragmentDefinition = this.fragmentsByName.get(fragmentSpread.getName());
        if (!this.conditionalNodes.shouldInclude(this.variables, fragmentDefinition.getDirectives())) {
            return;
        }
        GraphQLCompositeType typeCondition = (GraphQLCompositeType)this.schema.getType(fragmentDefinition.getTypeCondition().getName());
        this.visitImpl(visitor, fragmentDefinition.getSelectionSet(), typeCondition, parent, preOrder);
    }

    private void visitInlineFragment(QueryVisitor visitor, InlineFragment inlineFragment, GraphQLCompositeType parentType, QueryVisitorEnvironment parent, boolean preOrder) {
        GraphQLCompositeType fragmentCondition;
        if (!this.conditionalNodes.shouldInclude(this.variables, inlineFragment.getDirectives())) {
            return;
        }
        if (inlineFragment.getTypeCondition() != null) {
            TypeName typeCondition = inlineFragment.getTypeCondition();
            fragmentCondition = (GraphQLCompositeType)this.schema.getType(typeCondition.getName());
        } else {
            fragmentCondition = parentType;
        }
        this.visitImpl(visitor, inlineFragment.getSelectionSet(), fragmentCondition, parent, preOrder);
    }

    private void visitField(QueryVisitor visitor, Field field, GraphQLFieldDefinition fieldDefinition, GraphQLCompositeType parentType, QueryVisitorEnvironment parentEnv, boolean preOrder) {
        GraphQLUnmodifiedType unmodifiedType;
        if (!this.conditionalNodes.shouldInclude(this.variables, field.getDirectives())) {
            return;
        }
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), this.variables);
        if (preOrder) {
            visitor.visitField(new QueryVisitorEnvironment(field, fieldDefinition, parentType, parentEnv, argumentValues));
        }
        if ((unmodifiedType = this.schemaUtil.getUnmodifiedType(fieldDefinition.getType())) instanceof GraphQLCompositeType) {
            QueryVisitorEnvironment newParentEnvironment = new QueryVisitorEnvironment(field, fieldDefinition, parentType, parentEnv, argumentValues);
            this.visitImpl(visitor, field.getSelectionSet(), (GraphQLCompositeType)((Object)unmodifiedType), newParentEnvironment, preOrder);
        }
        if (!preOrder) {
            visitor.visitField(new QueryVisitorEnvironment(field, fieldDefinition, parentType, parentEnv, argumentValues));
        }
    }
}

