/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphqlErrorHelper;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.RecognitionException;

public class InvalidSyntaxError
implements GraphQLError {
    private final String message;
    private final List<SourceLocation> locations = new ArrayList<SourceLocation>();

    public InvalidSyntaxError(SourceLocation sourceLocation, String msg) {
        this.message = this.mkMessage(msg);
        if (sourceLocation != null) {
            this.locations.add(sourceLocation);
        }
    }

    public InvalidSyntaxError(List<SourceLocation> sourceLocations, String msg) {
        this.message = this.mkMessage(msg);
        if (sourceLocations != null) {
            this.locations.addAll(sourceLocations);
        }
    }

    private String mkMessage(String msg) {
        return "Invalid Syntax" + (msg == null ? "" : " : " + msg);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.InvalidSyntax;
    }

    public String toString() {
        return "InvalidSyntaxError{ message=" + this.message + " ,locations=" + this.locations + '}';
    }

    public static InvalidSyntaxError toInvalidSyntaxError(Exception parseException) {
        String msg = parseException.getMessage();
        SourceLocation sourceLocation = null;
        if (parseException.getCause() instanceof RecognitionException) {
            RecognitionException recognitionException = (RecognitionException)parseException.getCause();
            msg = recognitionException.getMessage();
            sourceLocation = new SourceLocation(recognitionException.getOffendingToken().getLine(), recognitionException.getOffendingToken().getCharPositionInLine());
        }
        return new InvalidSyntaxError(sourceLocation, msg);
    }

    public boolean equals(Object o) {
        return GraphqlErrorHelper.equals(this, o);
    }

    public int hashCode() {
        return GraphqlErrorHelper.hashCode(this);
    }
}

