/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.generator.mapping.strategy.ScalarMappingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapToListTypeAdapter<K, V>
extends AbstractTypeAdapter<Map<K, V>, List<MapEntry<K, V>>> {
    private final ScalarMappingStrategy scalarStrategy;

    public MapToListTypeAdapter(ScalarMappingStrategy scalarStrategy) {
        this.scalarStrategy = scalarStrategy;
    }

    @Override
    public List<MapEntry<K, V>> convertOutput(Map<K, V> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return original.entrySet().stream().map(entry -> new MapEntry(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<K, V> convertInput(List<MapEntry<K, V>> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        return original.stream().collect(Collectors.toMap(MapEntry::getKey, MapEntry::getValue));
    }

    @Override
    public AnnotatedType getSubstituteType(AnnotatedType original) {
        AnnotatedType keyType = this.getElementType(original, 0);
        AnnotatedType valueType = this.getElementType(original, 1);
        Type entryType = TypeFactory.parameterizedClass(MapEntry.class, (Type[])new Type[]{keyType.getType(), valueType.getType()});
        return GenericTypeReflector.annotate((Type)TypeFactory.parameterizedClass(List.class, (Type[])new Type[]{entryType}), (Annotation[])original.getAnnotations());
    }

    @Override
    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        return new GraphQLList((GraphQLType)this.mapEntry(operationMapper.toGraphQLType(this.getElementType(javaType, 0), abstractTypes, buildContext), operationMapper.toGraphQLType(this.getElementType(javaType, 1), abstractTypes, buildContext), buildContext));
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        return new GraphQLList((GraphQLType)this.mapEntry(operationMapper.toGraphQLInputType(this.getElementType(javaType, 0), abstractTypes, buildContext), operationMapper.toGraphQLInputType(this.getElementType(javaType, 1), abstractTypes, buildContext), buildContext));
    }

    @Override
    public boolean supports(AnnotatedType type) {
        return super.supports(type) && !this.scalarStrategy.supports(type);
    }

    private GraphQLOutputType mapEntry(GraphQLOutputType keyType, GraphQLOutputType valueType, BuildContext buildContext) {
        String typeName = "mapEntry_" + keyType.getName() + "_" + valueType.getName();
        if (buildContext.knownTypes.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        buildContext.knownTypes.add(typeName);
        return GraphQLObjectType.newObject().name(typeName).description("Map entry").field(GraphQLFieldDefinition.newFieldDefinition().name("key").description("Map key").type(keyType).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("value").description("Map value").type(valueType).build()).build();
    }

    private GraphQLInputType mapEntry(GraphQLInputType keyType, GraphQLInputType valueType, BuildContext buildContext) {
        String typeName = "mapEntry_" + keyType.getName() + "_" + valueType.getName() + "_input";
        if (buildContext.knownInputTypes.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        buildContext.knownInputTypes.add(typeName);
        return GraphQLInputObjectType.newInputObject().name(typeName).description("Map entry input").field(GraphQLInputObjectField.newInputObjectField().name("key").description("Map key input").type(keyType).build()).field(GraphQLInputObjectField.newInputObjectField().name("value").description("Map value input").type(valueType).build()).build();
    }

    private AnnotatedType getElementType(AnnotatedType javaType, int index) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, Map.class.getTypeParameters()[index]);
    }

    public static class MapEntry<K, V> {
        private K key;
        private V value;

        public MapEntry() {
        }

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

