/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.common;

import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLOutputType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.OperationMapper;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractionCollectingMapper
implements TypeMapper {
    @Override
    public GraphQLOutputType toGraphQLType(AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        this.registerAbstract(javaType, abstractTypes, buildContext);
        return this.graphQLType(javaType, abstractTypes, operationMapper, buildContext);
    }

    @Override
    public GraphQLInputType toGraphQLInputType(AnnotatedType javaType, Set<Type> abstractTypes, OperationMapper operationMapper, BuildContext buildContext) {
        this.registerAbstract(javaType, abstractTypes, buildContext);
        return this.graphQLInputType(javaType, abstractTypes, operationMapper, buildContext);
    }

    protected abstract GraphQLOutputType graphQLType(AnnotatedType var1, Set<Type> var2, OperationMapper var3, BuildContext var4);

    protected abstract GraphQLInputType graphQLInputType(AnnotatedType var1, Set<Type> var2, OperationMapper var3, BuildContext var4);

    protected void registerAbstract(AnnotatedType type, Set<Type> abstractTypes, BuildContext buildContext) {
        if (ClassUtils.isAbstract(type)) {
            abstractTypes.add(type.getType());
        }
    }

    protected Set<Type> collectAbstract(AnnotatedType javaType, Set<Type> seen, BuildContext buildContext) {
        if (Scalars.isScalar((javaType = buildContext.globalEnvironment.converters.getMappableType(javaType)).getType())) {
            return Collections.emptySet();
        }
        if (GenericTypeReflector.isSuperType(Collection.class, (Type)javaType.getType())) {
            AnnotatedType elementType = GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, Collection.class.getTypeParameters()[0]);
            return this.collectAbstractInner(elementType, seen, buildContext);
        }
        if (GenericTypeReflector.isSuperType(Map.class, (Type)javaType.getType())) {
            AnnotatedType keyType = GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, Map.class.getTypeParameters()[0]);
            AnnotatedType valueType = GenericTypeReflector.getTypeParameter((AnnotatedType)javaType, Map.class.getTypeParameters()[1]);
            Set<Type> abstractTypes = this.collectAbstractInner(keyType, seen, buildContext);
            abstractTypes.addAll(this.collectAbstractInner(valueType, seen, buildContext));
            return abstractTypes;
        }
        return this.collectAbstractInner(javaType, seen, buildContext);
    }

    private Set<Type> collectAbstractInner(AnnotatedType javaType, Set<Type> seen, BuildContext buildContext) {
        if (buildContext.abstractComponentTypes.containsKey(javaType.getType())) {
            return buildContext.abstractComponentTypes.get(javaType.getType());
        }
        if (seen.contains(javaType.getType())) {
            return Collections.emptySet();
        }
        seen.add(javaType.getType());
        HashSet<Type> abstractTypes = new HashSet<Type>();
        if (ClassUtils.isAbstract(javaType)) {
            abstractTypes.add(javaType.getType());
        }
        buildContext.inputFieldStrategy.getInputFields(javaType).forEach(childQuery -> abstractTypes.addAll(this.collectAbstract(childQuery.getJavaType(), seen, buildContext)));
        buildContext.abstractComponentTypes.put(javaType.getType(), abstractTypes);
        return abstractTypes;
    }
}

