/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.generator.mapping.InputConverter;
import io.leangen.graphql.generator.mapping.OutputConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConverterRepository {
    private final List<InputConverter> inputConverters;
    private final List<OutputConverter> outputConverters;

    public ConverterRepository(List<InputConverter> inputConverters, List<OutputConverter> outputConverters) {
        this.inputConverters = Collections.unmodifiableList(inputConverters);
        this.outputConverters = Collections.unmodifiableList(outputConverters);
    }

    public InputConverter getInputConverter(AnnotatedType inputType) {
        return this.inputConverters.stream().filter(conv -> conv.supports(inputType)).findFirst().orElse(null);
    }

    public OutputConverter getOutputConverter(AnnotatedType outputType) {
        return this.outputConverters.stream().filter(conv -> conv.supports(outputType)).findFirst().orElse(null);
    }

    public AnnotatedType getMappableType(AnnotatedType type) {
        InputConverter converter = this.getInputConverter(type);
        if (converter != null) {
            return this.getMappableType(converter.getSubstituteType(type));
        }
        if (type.getType() instanceof Class) {
            return type;
        }
        if (type instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] arguments = (AnnotatedType[])Arrays.stream(parameterizedType.getAnnotatedActualTypeArguments()).map(this::getMappableType).toArray(AnnotatedType[]::new);
            return TypeFactory.parameterizedAnnotatedClass((Class)GenericTypeReflector.erase((Type)type.getType()), (Annotation[])type.getAnnotations(), (AnnotatedType[])arguments);
        }
        throw new IllegalArgumentException("Can not deserialize type: " + type.getType().getTypeName());
    }
}

